/*
 * Decompiled with CFR 0.152.
 */
package snow.player.exo.util;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public final class OkHttpUtil {
    private OkHttpUtil() {
        throw new AssertionError();
    }

    public static void enableTls12OnPreLollipop(OkHttpClient.Builder builder) {
        OkHttpUtil.enableTls12OnPreLollipop(builder, false);
    }

    public static void enableTls12OnPreLollipop(OkHttpClient.Builder builder, boolean trustAllCertificate) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22) {
            try {
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                if (trustAllCertificate) {
                    TrustManager[] trustAllCerts = OkHttpUtil.getUnsafeTrustManager();
                    sc.init(null, trustAllCerts, new SecureRandom());
                    builder.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()), (X509TrustManager)trustAllCerts[0]);
                } else {
                    sc.init(null, null, null);
                    builder.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()));
                }
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                builder.connectionSpecs(specs);
            }
            catch (Exception exc) {
                Log.e((String)"OkHttpUtil", (String)"Error while setting TLS 1.2", (Throwable)exc);
            }
        }
    }

    private static TrustManager[] getUnsafeTrustManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
    }

    private static class Tls12SocketFactory
    extends SSLSocketFactory {
        private static final String[] TLS_V12_ONLY = new String[]{"TLSv1.2"};
        final SSLSocketFactory delegate;

        public Tls12SocketFactory(SSLSocketFactory base) {
            this.delegate = base;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.patch(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.patch(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.patch(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.patch(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.patch(this.delegate.createSocket(address, port, localAddress, localPort));
        }

        private Socket patch(Socket s) {
            if (s instanceof SSLSocket) {
                ((SSLSocket)s).setEnabledProtocols(TLS_V12_ONLY);
            }
            return s;
        }
    }
}

