/*
 * Decompiled with CFR 0.152.
 */
package media.helper;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import media.helper.ObjectUtil;

public class BecomeNoiseHelper {
    private Context mContext;
    private OnBecomeNoiseListener mListener;
    private BroadcastReceiver mBecomeNoiseReceiver;
    private boolean mRegistered;

    public BecomeNoiseHelper(@NonNull Context context, @NonNull OnBecomeNoiseListener listener) {
        ObjectUtil.requireNonNull(context);
        ObjectUtil.requireNonNull(listener);
        this.mContext = context.getApplicationContext();
        this.mListener = listener;
        this.mBecomeNoiseReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BecomeNoiseHelper.this.mListener.onBecomeNoise();
            }
        };
    }

    public void registerBecomeNoiseReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        this.mContext.registerReceiver(this.mBecomeNoiseReceiver, intentFilter);
        this.mRegistered = true;
    }

    public void unregisterBecomeNoiseReceiver() {
        if (this.mRegistered) {
            this.mContext.unregisterReceiver(this.mBecomeNoiseReceiver);
            this.mRegistered = false;
        }
    }

    public static interface OnBecomeNoiseListener {
        public void onBecomeNoise();
    }
}

