/*
 * Decompiled with CFR 0.152.
 */
package media.helper;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import media.helper.ObjectUtil;

public class AudioFocusHelper {
    @Nullable
    private AudioManager mAudioManager;
    private OnAudioFocusChangeListener mListener;
    private AudioFocusRequest mAudioFocusRequest;
    private AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener;
    private boolean mLossTransient;
    private boolean mLossTransientCanDuck;
    private boolean mRequested;

    public AudioFocusHelper(@NonNull Context context, @NonNull OnAudioFocusChangeListener listener) {
        ObjectUtil.requireNonNull(context);
        ObjectUtil.requireNonNull(listener);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mListener = listener;
        this.initAudioFocusChangeListener();
    }

    public AudioFocusHelper(@NonNull Context context, @NonNull AudioManager.OnAudioFocusChangeListener listener) {
        ObjectUtil.requireNonNull(context);
        ObjectUtil.requireNonNull(listener);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioFocusChangeListener = listener;
    }

    private void initAudioFocusChangeListener() {
        this.mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case -1: {
                        AudioFocusHelper.this.mListener.onLoss();
                        AudioFocusHelper.this.mLossTransient = false;
                        AudioFocusHelper.this.mLossTransientCanDuck = false;
                        break;
                    }
                    case -2: {
                        AudioFocusHelper.this.mLossTransient = true;
                        AudioFocusHelper.this.mListener.onLossTransient();
                        break;
                    }
                    case -3: {
                        AudioFocusHelper.this.mLossTransientCanDuck = true;
                        AudioFocusHelper.this.mListener.onLossTransientCanDuck();
                        break;
                    }
                    case 1: {
                        AudioFocusHelper.this.mListener.onGain(AudioFocusHelper.this.mLossTransient, AudioFocusHelper.this.mLossTransientCanDuck);
                        AudioFocusHelper.this.mLossTransient = false;
                        AudioFocusHelper.this.mLossTransientCanDuck = false;
                    }
                }
            }
        };
    }

    public int requestAudioFocus(int streamType, int durationHint) {
        if (this.mAudioManager == null) {
            return 0;
        }
        this.mRequested = true;
        if (Build.VERSION.SDK_INT >= 26) {
            return this.requestAudioFocusAPI26(streamType, durationHint);
        }
        return this.mAudioManager.requestAudioFocus(this.mAudioFocusChangeListener, streamType, durationHint);
    }

    @RequiresApi(value=26)
    private int requestAudioFocusAPI26(int streamType, int durationHint) {
        if (this.mAudioManager == null) {
            return 0;
        }
        this.mAudioFocusRequest = new AudioFocusRequest.Builder(durationHint).setAudioAttributes(new AudioAttributes.Builder().setLegacyStreamType(streamType).build()).setOnAudioFocusChangeListener(this.mAudioFocusChangeListener).build();
        return this.mAudioManager.requestAudioFocus(this.mAudioFocusRequest);
    }

    public void abandonAudioFocus() {
        if (this.mAudioManager == null || !this.mRequested) {
            return;
        }
        this.mRequested = false;
        if (Build.VERSION.SDK_INT >= 26) {
            this.abandonAudioFocusAPI26();
            return;
        }
        this.mAudioManager.abandonAudioFocus(this.mAudioFocusChangeListener);
    }

    @RequiresApi(api=26)
    private void abandonAudioFocusAPI26() {
        ObjectUtil.requireNonNull(this.mAudioManager);
        this.mAudioManager.abandonAudioFocusRequest(this.mAudioFocusRequest);
    }

    public static interface OnAudioFocusChangeListener {
        public void onLoss();

        public void onLossTransient();

        public void onLossTransientCanDuck();

        public void onGain(boolean var1, boolean var2);
    }
}

