/*
 * Decompiled with CFR 0.152.
 */
package channel.helper.pipe;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.media.session.MediaSessionCompat;
import channel.helper.Dispatcher;
import channel.helper.Emitter;
import channel.helper.pipe.MapWrapper;
import java.util.Map;

public final class SessionEventPipe
implements Emitter {
    private static final String SESSION_EVENT = "channel.helper.pipe.SESSION_EVENT";
    private static final String KET_EXTRA = "extra";
    private MediaSessionCompat mMediaSessionCompat;
    private Dispatcher mDispatcher;

    public SessionEventPipe(MediaSessionCompat mediaSessionCompat) {
        this.mMediaSessionCompat = mediaSessionCompat;
    }

    public SessionEventPipe(Dispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    public void emit(Map<String, Object> data) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KET_EXTRA, (Parcelable)new MapWrapper(data));
        this.mMediaSessionCompat.sendSessionEvent(SESSION_EVENT, bundle);
    }

    public boolean dispatch(String action, Bundle data) {
        if (!SESSION_EVENT.equals(action)) {
            return false;
        }
        MapWrapper wrapper = (MapWrapper)data.getParcelable(KET_EXTRA);
        if (wrapper == null) {
            return false;
        }
        return this.mDispatcher.dispatch(wrapper.getMap());
    }
}

