/*
 * Decompiled with CFR 0.152.
 */
package channel.helper;

import channel.helper.Dispatcher;
import channel.helper.Emitter;
import java.lang.reflect.Constructor;

public final class ChannelHelper {
    private ChannelHelper() {
        throw new AssertionError();
    }

    public static <T> T newEmitter(Class<T> clazz, Emitter pipe) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe is null");
        }
        String emitterName = clazz.getName() + "__ChannelHelper$Emitter";
        try {
            Class<?> emitter = Class.forName(emitterName);
            Constructor<?> constructor = emitter.getConstructor(Emitter.class);
            return (T)constructor.newInstance(pipe);
        }
        catch (Exception e) {
            throw new IllegalStateException("emitter create failed", e);
        }
    }

    public static <T> Dispatcher newDispatcher(Class<T> clazz, T receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver is null");
        }
        String dispatcherName = clazz.getName() + "__ChannelHelper$Dispatcher";
        try {
            Class<?> dispatcher = Class.forName(dispatcherName);
            Constructor<?> constructor = dispatcher.getConstructor(clazz);
            return (Dispatcher)constructor.newInstance(receiver);
        }
        catch (Exception e) {
            throw new IllegalStateException("dispatcher create failed", e);
        }
    }
}

