/*
 * Decompiled with CFR 0.152.
 */
package math.function;

import math.function.Function;
import math.function.MultivariateDoubleFunction;
import math.function.MultivariateFunction;
import math.linear.doubles.Vector;

public final class NumericalDerivatives {
    private NumericalDerivatives() {
    }

    public static double forwardDifferenceApproximation(Function f, double point, double h) {
        return (f.at(point) - f.at(point - h)) / h;
    }

    public static double centralDifferenceApproximation(Function f, double point, double h) {
        return (f.at(point + 0.5 * h) - f.at(point - 0.5 * h)) / h;
    }

    public static double forwardDifferenceApproximation(Function f, double point, double h, double functionValue) {
        return (functionValue - f.at(point - h)) / h;
    }

    public static double[] forwardDifferenceGradient(MultivariateDoubleFunction f, double[] point, double h) {
        double[] newPoints = (double[])point.clone();
        double[] partials = new double[point.length];
        double functionValue = f.at(point);
        for (int i = 0; i < partials.length; ++i) {
            newPoints[i] = point[i] + h;
            partials[i] = (f.at(newPoints) - functionValue) / h;
            newPoints = (double[])point.clone();
        }
        return partials;
    }

    public static double[] centralDifferenceGradient(MultivariateDoubleFunction f, double[] point, double h) {
        double[] forwardPoints = (double[])point.clone();
        double[] backwardPoints = (double[])point.clone();
        double[] partials = new double[point.length];
        for (int i = 0; i < partials.length; ++i) {
            forwardPoints[i] = point[i] + 0.5 * h;
            backwardPoints[i] = point[i] - 0.5 * h;
            partials[i] = (f.at(forwardPoints) - f.at(backwardPoints)) / h;
            forwardPoints = (double[])point.clone();
            backwardPoints = (double[])point.clone();
        }
        return partials;
    }

    public static Vector forwardDifferenceGradient(MultivariateFunction f, Vector point, double h) {
        double[] newPoints = (double[])point.elements().clone();
        double[] partials = new double[point.size()];
        double functionValue = f.at(point);
        for (int i = 0; i < partials.length; ++i) {
            newPoints[i] = point.at(i) + h;
            partials[i] = (f.at(Vector.from(newPoints)) - functionValue) / h;
            newPoints = (double[])point.elements().clone();
        }
        return Vector.from(partials);
    }

    public static Vector forwardDifferenceGradient(MultivariateFunction f, Vector point, double h, double functionValue) {
        double[] newPoints = (double[])point.elements().clone();
        double[] partials = new double[point.size()];
        for (int i = 0; i < partials.length; ++i) {
            newPoints[i] = point.at(i) + h;
            partials[i] = (f.at(Vector.from(newPoints)) - functionValue) / h;
            newPoints = (double[])point.elements().clone();
        }
        return Vector.from(partials);
    }

    public static Vector centralDifferenceGradient(MultivariateFunction f, Vector point, double h) {
        double[] forwardPoints = (double[])point.elements().clone();
        double[] backwardPoints = (double[])point.elements().clone();
        double[] partials = new double[point.size()];
        for (int i = 0; i < partials.length; ++i) {
            forwardPoints[i] = point.at(i) + h;
            backwardPoints[i] = point.at(i) - h;
            partials[i] = (f.at(Vector.from(forwardPoints)) - f.at(Vector.from(backwardPoints))) / (2.0 * h);
            forwardPoints = (double[])point.elements().clone();
            backwardPoints = (double[])point.elements().clone();
        }
        return Vector.from(partials);
    }
}

