/*
 * Decompiled with CFR 0.152.
 */
package math;

import lombok.NonNull;
import math.FieldElement;
import math.Real;

public final class Rational
implements FieldElement<Rational> {
    private final int p;
    private final int q;

    public static Rational from(int p, int q) {
        return new Rational(p, q);
    }

    public static Rational from(int p) {
        return new Rational(p, 1);
    }

    private Rational(int p, int q) {
        if (q == 0) {
            throw new IllegalArgumentException("The denominator cannot be zero.");
        }
        this.p = p;
        this.q = q;
    }

    @Override
    public Rational plus(Rational other) {
        return new Rational(this.p * other.q + other.p * this.q, this.q * other.q);
    }

    @Override
    public Rational minus(Rational other) {
        return new Rational(this.p * other.q - other.p * this.q, this.q * other.q);
    }

    @Override
    public Rational times(Rational other) {
        this.checkNonZero(other.q);
        return new Rational(this.p * other.p, this.q * other.q);
    }

    @Override
    public Rational sqrt() {
        double top = Math.sqrt(this.p);
        if (Math.abs(top - (double)((int)top)) > 0.0 || !Double.isFinite(top)) {
            throw new IllegalStateException("The square root of the rational number is not rational.");
        }
        double bottom = Math.sqrt(this.q);
        if (Math.abs(bottom - (double)((int)bottom)) > 0.0 || !Double.isFinite(bottom)) {
            throw new IllegalStateException("The square root of the rational number is not rational.");
        }
        return new Rational((int)top, (int)bottom);
    }

    @Override
    public Rational conjugate() {
        return this;
    }

    @Override
    public Rational additiveInverse() {
        return new Rational(-this.p, this.q);
    }

    @Override
    public double abs() {
        return Math.abs((double)this.p / (double)this.q);
    }

    @Override
    public Rational dividedBy(Rational value) {
        this.checkNonZero(value.p);
        return new Rational(this.p * value.q, this.q * value.p);
    }

    private void checkNonZero(int value) {
        if (value == 0) {
            throw new ArithmeticException("Attempt to divide a rational number by zero.");
        }
    }

    @Override
    public int compareTo(@NonNull Rational other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        double thisVal = Real.from((double)this.p / (double)this.q).asDouble();
        double otherVal = Real.from((double)other.p / (double)other.q).asDouble();
        return Double.compare(thisVal, otherVal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Rational: ");
        if (this.p == 0) {
            return sb.append("0").toString();
        }
        if (this.q == 1) {
            return sb.append(Integer.toString(this.p)).toString();
        }
        if ((double)this.p / (double)this.q == 1.0) {
            return sb.append("1").toString();
        }
        if (this.p < 0) {
            if (this.q < 0) {
                return sb.append(-this.p).append("/").append(-this.q).toString();
            }
            return sb.append(this.p).append("/").append(this.q).toString();
        }
        if (this.q < 0) {
            return sb.append(-this.p).append("/").append(-this.q).toString();
        }
        return sb.append(this.p).append("/").append(this.q).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rational rational = (Rational)o;
        Real real = Real.from((double)this.p / (double)this.q);
        Real otherReal = Real.from((double)rational.p / (double)rational.q);
        return real.equals(otherReal);
    }

    public int hashCode() {
        Real real = Real.from((double)this.p / (double)this.q);
        int result = real.hashCode();
        return result * 31;
    }
}

