/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.rilixtech.Country;
import com.rilixtech.CountryCodeArrayAdapter;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.R;
import java.util.ArrayList;
import java.util.List;

class CountryCodeDialog
extends Dialog {
    private EditText mEdtSearch;
    private TextView mTvNoResult;
    private TextView mTvTitle;
    private ListView mLvCountryDialog;
    private CountryCodePicker mCountryCodePicker;
    private RelativeLayout mRlyDialog;
    private List<Country> masterCountries;
    private List<Country> mFilteredCountries;
    private InputMethodManager mInputMethodManager;
    private CountryCodeArrayAdapter mArrayAdapter;
    private List<Country> mTempCountries;

    CountryCodeDialog(CountryCodePicker countryCodePicker) {
        super(countryCodePicker.getContext());
        this.mCountryCodePicker = countryCodePicker;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.layout_picker_dialog);
        this.setupUI();
        this.setupData();
    }

    private void setupUI() {
        this.mRlyDialog = (RelativeLayout)this.findViewById(R.id.dialog_rly);
        this.mLvCountryDialog = (ListView)this.findViewById(R.id.country_dialog_lv);
        this.mTvTitle = (TextView)this.findViewById(R.id.title_tv);
        this.mEdtSearch = (EditText)this.findViewById(R.id.search_edt);
        this.mTvNoResult = (TextView)this.findViewById(R.id.no_result_tv);
    }

    private void setupData() {
        if (this.mCountryCodePicker.getTypeFace() != null) {
            Typeface typeface = this.mCountryCodePicker.getTypeFace();
            this.mTvTitle.setTypeface(typeface);
            this.mEdtSearch.setTypeface(typeface);
            this.mTvNoResult.setTypeface(typeface);
        }
        if (this.mCountryCodePicker.getBackgroundColor() != this.mCountryCodePicker.getDefaultBackgroundColor()) {
            this.mRlyDialog.setBackgroundColor(this.mCountryCodePicker.getBackgroundColor());
        }
        if (this.mCountryCodePicker.getDialogTextColor() != this.mCountryCodePicker.getDefaultContentColor()) {
            int color2 = this.mCountryCodePicker.getDialogTextColor();
            this.mTvTitle.setTextColor(color2);
            this.mTvNoResult.setTextColor(color2);
            this.mEdtSearch.setTextColor(color2);
            this.mEdtSearch.setHintTextColor(this.adjustAlpha(color2, 0.7f));
        }
        this.mCountryCodePicker.refreshCustomMasterList();
        this.mCountryCodePicker.refreshPreferredCountries();
        this.masterCountries = this.mCountryCodePicker.getCustomCountries(this.mCountryCodePicker);
        this.mFilteredCountries = this.getFilteredCountries();
        this.setupListView(this.mLvCountryDialog);
        this.mInputMethodManager = (InputMethodManager)this.mCountryCodePicker.getContext().getSystemService("input_method");
        this.setSearchBar();
    }

    private void setupListView(ListView listView) {
        this.mArrayAdapter = new CountryCodeArrayAdapter(this.getContext(), this.mFilteredCountries, this.mCountryCodePicker);
        if (!this.mCountryCodePicker.isSelectionDialogShowSearch()) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)listView.getLayoutParams();
            params.height = -2;
            listView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)new ItemRecyclerViewClickListener());
        listView.setAdapter((ListAdapter)this.mArrayAdapter);
    }

    private int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private void setSearchBar() {
        if (this.mCountryCodePicker.isSelectionDialogShowSearch()) {
            this.setTextWatcher();
        } else {
            this.mEdtSearch.setVisibility(8);
        }
    }

    private void setTextWatcher() {
        if (this.mEdtSearch == null) {
            return;
        }
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                CountryCodeDialog.this.applyQuery(s.toString());
            }
        });
        if (this.mCountryCodePicker.isKeyboardAutoPopOnSearch() && this.mInputMethodManager != null) {
            this.mInputMethodManager.toggleSoftInput(2, 0);
        }
    }

    private void applyQuery(String query) {
        this.mTvNoResult.setVisibility(8);
        query = query.toLowerCase();
        if (query.length() > 0 && query.charAt(0) == '+') {
            query = query.substring(1);
        }
        this.mFilteredCountries = this.getFilteredCountries(query);
        if (this.mFilteredCountries.size() == 0) {
            this.mTvNoResult.setVisibility(0);
        }
        this.mArrayAdapter.notifyDataSetChanged();
    }

    private List<Country> getFilteredCountries() {
        return this.getFilteredCountries("");
    }

    private List<Country> getFilteredCountries(String query) {
        if (this.mTempCountries == null) {
            this.mTempCountries = new ArrayList<Country>();
        } else {
            this.mTempCountries.clear();
        }
        List<Country> preferredCountries = this.mCountryCodePicker.getPreferredCountries();
        if (preferredCountries != null && preferredCountries.size() > 0) {
            for (Country country : preferredCountries) {
                if (!country.isEligibleForQuery(query)) continue;
                this.mTempCountries.add(country);
            }
            if (this.mTempCountries.size() > 0) {
                this.mTempCountries.add(null);
            }
        }
        for (Country country : this.masterCountries) {
            if (!country.isEligibleForQuery(query)) continue;
            this.mTempCountries.add(country);
        }
        return this.mTempCountries;
    }

    public class ItemRecyclerViewClickListener
    implements AdapterView.OnItemClickListener {
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            CountryCodeDialog.this.mCountryCodePicker.setSelectedCountry((Country)CountryCodeDialog.this.mFilteredCountries.get(position));
            CountryCodeDialog.this.mInputMethodManager.hideSoftInputFromWindow(CountryCodeDialog.this.mEdtSearch.getWindowToken(), 0);
            CountryCodeDialog.this.dismiss();
        }
    }
}

