/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.content.Context;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.rilixtech.Country;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.CountryUtils;
import com.rilixtech.R;
import java.util.List;

class CountryCodeAdapter
extends RecyclerView.Adapter<CountryCodeViewHolder> {
    private List<Country> mCountries;
    private CountryCodePicker mCountryCodePicker;
    private Callback mCallback;

    CountryCodeAdapter(List<Country> countries, CountryCodePicker codePicker, Callback callback) {
        this.mCountries = countries;
        this.mCountryCodePicker = codePicker;
        this.mCallback = callback;
    }

    public CountryCodeViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        LayoutInflater inflater = LayoutInflater.from((Context)viewGroup.getContext());
        View rootView = inflater.inflate(R.layout.layout_recycler_country_tile, viewGroup, false);
        return new CountryCodeViewHolder(rootView);
    }

    public void onBindViewHolder(CountryCodeViewHolder viewHolder, int i) {
        final int position = viewHolder.getAdapterPosition();
        viewHolder.setCountry(this.mCountries.get(position));
        viewHolder.rlyMain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CountryCodeAdapter.this.mCallback.onItemCountrySelected((Country)CountryCodeAdapter.this.mCountries.get(position));
            }
        });
    }

    public int getItemCount() {
        return this.mCountries.size();
    }

    class CountryCodeViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout rlyMain;
        AppCompatTextView tvName;
        AppCompatTextView tvCode;
        AppCompatImageView imvFlag;
        LinearLayout llyFlagHolder;
        View viewDivider;

        CountryCodeViewHolder(View itemView) {
            super(itemView);
            this.rlyMain = (RelativeLayout)itemView;
            this.tvName = (AppCompatTextView)this.rlyMain.findViewById(R.id.country_name_tv);
            this.tvCode = (AppCompatTextView)this.rlyMain.findViewById(R.id.code_tv);
            this.imvFlag = (AppCompatImageView)this.rlyMain.findViewById(R.id.flag_imv);
            this.llyFlagHolder = (LinearLayout)this.rlyMain.findViewById(R.id.flag_holder_lly);
            this.viewDivider = this.rlyMain.findViewById(R.id.preference_divider_view);
        }

        private void setCountry(Country country) {
            if (country != null) {
                this.viewDivider.setVisibility(8);
                this.tvName.setVisibility(0);
                this.tvCode.setVisibility(0);
                this.llyFlagHolder.setVisibility(0);
                String countryNameAndCode = this.tvName.getContext().getString(R.string.country_name_and_code, new Object[]{country.getName(), country.getIso().toUpperCase()});
                this.tvName.setText((CharSequence)countryNameAndCode);
                if (!CountryCodeAdapter.this.mCountryCodePicker.isHidePhoneCode()) {
                    this.tvCode.setText((CharSequence)this.tvCode.getContext().getString(R.string.phone_code, new Object[]{country.getPhoneCode()}));
                } else {
                    this.tvCode.setVisibility(8);
                }
                if (CountryCodeAdapter.this.mCountryCodePicker.getTypeFace() != null) {
                    this.tvCode.setTypeface(CountryCodeAdapter.this.mCountryCodePicker.getTypeFace());
                    this.tvName.setTypeface(CountryCodeAdapter.this.mCountryCodePicker.getTypeFace());
                }
                this.imvFlag.setImageResource(CountryUtils.getFlagDrawableResId(country));
                if (CountryCodeAdapter.this.mCountryCodePicker.getDialogTextColor() != CountryCodeAdapter.this.mCountryCodePicker.getDefaultContentColor()) {
                    int color2 = CountryCodeAdapter.this.mCountryCodePicker.getDialogTextColor();
                    this.tvCode.setTextColor(color2);
                    this.tvName.setTextColor(color2);
                }
            } else {
                this.viewDivider.setVisibility(0);
                this.tvName.setVisibility(8);
                this.tvCode.setVisibility(8);
                this.llyFlagHolder.setVisibility(8);
            }
        }
    }

    static interface Callback {
        public void onItemCountrySelected(Country var1);
    }
}

