/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.telephony.TelephonyManager;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.rilixtech.Country;
import com.rilixtech.CountryCodeDialog;
import com.rilixtech.CountryUtils;
import com.rilixtech.R;
import io.michaelrocks.libphonenumber.android.NumberParseException;
import io.michaelrocks.libphonenumber.android.PhoneNumberUtil;
import io.michaelrocks.libphonenumber.android.Phonenumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class CountryCodePicker
extends RelativeLayout {
    private static String TAG = CountryCodePicker.class.getSimpleName();
    private final String DEFAULT_COUNTRY = Locale.getDefault().getCountry();
    private static final int DEFAULT_COUNTRY_CODE = 62;
    private static final String DEFAULT_ISO_COUNTRY = "ID";
    private static final int DEFAULT_TEXT_COLOR = 0;
    private static final int DEFAULT_BACKGROUND_COLOR = 0;
    private int mBackgroundColor = 0;
    private int mDefaultCountryCode;
    private String mDefaultCountryNameCode;
    private PhoneNumberUtil mPhoneUtil;
    private PhoneNumberWatcher mPhoneNumberWatcher;
    PhoneNumberInputValidityListener mPhoneNumberInputValidityListener;
    private AppCompatTextView mTvSelectedCountry;
    private TextView mRegisteredPhoneNumberTextView;
    private RelativeLayout mRlyHolder;
    private AppCompatImageView mImvArrow;
    private AppCompatImageView mImvFlag;
    private LinearLayout mLlyFlagHolder;
    private Country mSelectedCountry;
    private Country mDefaultCountry;
    private RelativeLayout mRlyClickConsumer;
    View.OnClickListener mCountryCodeHolderClickListener;
    private boolean mHideNameCode = false;
    private boolean mShowFlag = true;
    private boolean mShowFullName = false;
    private boolean mUseFullName = false;
    private boolean mSelectionDialogShowSearch = true;
    private List<Country> mPreferredCountries;
    private String mCountryPreference;
    private List<Country> mCustomMasterCountriesList;
    private String mCustomMasterCountries;
    private boolean mKeyboardAutoPopOnSearch = true;
    private boolean mIsClickable = true;
    private CountryCodeDialog mCountryCodeDialog;
    private boolean mHidePhoneCode = false;
    private int mTextColor = 0;
    private Typeface mTypeFace;
    private boolean mIsHintEnabled = true;
    private boolean mIsEnablePhoneNumberWatcher = true;
    private boolean mSetCountryByTimeZone = true;
    private OnCountryChangeListener mOnCountryChangeListener;

    public CountryCodePicker(Context context) {
        super(context);
        this.init(null);
    }

    public CountryCodePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public CountryCodePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public CountryCodePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        CountryCodePicker.inflate((Context)this.getContext(), (int)R.layout.layout_code_picker, (ViewGroup)this);
        this.mTvSelectedCountry = (AppCompatTextView)this.findViewById(R.id.selected_country_tv);
        this.mRlyHolder = (RelativeLayout)this.findViewById(R.id.country_code_holder_rly);
        this.mImvArrow = (AppCompatImageView)this.findViewById(R.id.arrow_imv);
        this.mImvFlag = (AppCompatImageView)this.findViewById(R.id.flag_imv);
        this.mLlyFlagHolder = (LinearLayout)this.findViewById(R.id.flag_holder_lly);
        this.mRlyClickConsumer = (RelativeLayout)this.findViewById(R.id.click_consumer_rly);
        this.applyCustomProperty(attrs);
        this.mCountryCodeHolderClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (CountryCodePicker.this.isClickable()) {
                    if (CountryCodePicker.this.mCountryCodeDialog == null) {
                        CountryCodePicker.this.mCountryCodeDialog = new CountryCodeDialog(CountryCodePicker.this);
                        CountryCodePicker.this.mCountryCodeDialog.show();
                    } else {
                        CountryCodePicker.this.mCountryCodeDialog.reShow();
                    }
                }
            }
        };
        this.mRlyClickConsumer.setOnClickListener(this.mCountryCodeHolderClickListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCustomProperty(AttributeSet attrs) {
        this.mPhoneUtil = PhoneNumberUtil.createInstance((Context)this.getContext());
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CountryCodePicker, 0, 0);
        try {
            int textSize;
            String fontPath;
            this.mHidePhoneCode = a.getBoolean(R.styleable.CountryCodePicker_ccp_hidePhoneCode, false);
            this.mHideNameCode = a.getBoolean(R.styleable.CountryCodePicker_ccp_hideNameCode, false);
            this.mShowFullName = a.getBoolean(R.styleable.CountryCodePicker_ccp_showFullName, false);
            this.mIsHintEnabled = a.getBoolean(R.styleable.CountryCodePicker_ccp_enableHint, true);
            this.mIsEnablePhoneNumberWatcher = a.getBoolean(R.styleable.CountryCodePicker_ccp_enablePhoneAutoFormatter, true);
            this.setKeyboardAutoPopOnSearch(a.getBoolean(R.styleable.CountryCodePicker_ccp_keyboardAutoPopOnSearch, true));
            this.mCustomMasterCountries = a.getString(R.styleable.CountryCodePicker_ccp_customMasterCountries);
            this.refreshCustomMasterList();
            this.mCountryPreference = a.getString(R.styleable.CountryCodePicker_ccp_countryPreference);
            this.refreshPreferredCountries();
            this.mDefaultCountryNameCode = a.getString(R.styleable.CountryCodePicker_ccp_defaultNameCode);
            Log.d((String)TAG, (String)("mDefaultCountryNameCode from attribute = " + this.mDefaultCountryNameCode));
            boolean setUsingNameCode = false;
            if (this.mDefaultCountryNameCode != null && !this.mDefaultCountryNameCode.isEmpty()) {
                String temp = this.mDefaultCountryNameCode.trim();
                if (!temp.isEmpty()) {
                    this.setDefaultCountryUsingNameCode(this.mDefaultCountryNameCode);
                    if (this.mDefaultCountryNameCode != null) {
                        this.setSelectedCountry(this.mDefaultCountry);
                    }
                } else {
                    this.mDefaultCountryNameCode = null;
                }
            }
            this.showFlag(a.getBoolean(R.styleable.CountryCodePicker_ccp_showFlag, true));
            int textColor = this.isInEditMode() ? a.getColor(R.styleable.CountryCodePicker_ccp_textColor, 0) : a.getColor(R.styleable.CountryCodePicker_ccp_textColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.defaultTextColor));
            if (textColor != 0) {
                this.setTextColor(textColor);
            }
            this.mBackgroundColor = a.getColor(R.styleable.CountryCodePicker_ccp_backgroundColor, 0);
            if (this.mBackgroundColor != 0) {
                this.mRlyHolder.setBackgroundColor(this.mBackgroundColor);
            }
            if ((fontPath = a.getString(R.styleable.CountryCodePicker_ccp_textFont)) != null && !fontPath.isEmpty()) {
                this.setTypeFace(fontPath);
            }
            if ((textSize = a.getDimensionPixelSize(R.styleable.CountryCodePicker_ccp_textSize, 0)) > 0) {
                this.mTvSelectedCountry.setTextSize(0, (float)textSize);
                this.setFlagSize(textSize);
                this.setArrowSize(textSize);
            } else {
                DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
                int defaultSize = Math.round(18.0f * (dm.xdpi / 160.0f));
                this.setTextSize(defaultSize);
            }
            int arrowSize = a.getDimensionPixelSize(R.styleable.CountryCodePicker_ccp_arrowSize, 0);
            if (arrowSize > 0) {
                this.setArrowSize(arrowSize);
            }
            this.mSelectionDialogShowSearch = a.getBoolean(R.styleable.CountryCodePicker_ccp_selectionDialogShowSearch, true);
            this.setClickable(a.getBoolean(R.styleable.CountryCodePicker_ccp_clickable, true));
            this.mSetCountryByTimeZone = a.getBoolean(R.styleable.CountryCodePicker_ccp_setCountryByTimeZone, true);
            if (this.mDefaultCountryNameCode == null || this.mDefaultCountryNameCode.isEmpty()) {
                this.setDefaultCountryFlagAndCode();
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("exception = " + e.toString()));
            if (this.isInEditMode()) {
                this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.phone_code, new Object[]{this.getContext().getString(R.string.country_indonesia_number)}));
            } else {
                this.mTvSelectedCountry.setText((CharSequence)e.getMessage());
            }
        }
        finally {
            a.recycle();
        }
    }

    private Country getDefaultCountry() {
        return this.mDefaultCountry;
    }

    private void setDefaultCountry(Country defaultCountry) {
        this.mDefaultCountry = defaultCountry;
    }

    private Country getSelectedCountry() {
        return this.mSelectedCountry;
    }

    protected void setSelectedCountry(Country selectedCountry) {
        this.mSelectedCountry = selectedCountry;
        if (selectedCountry == null) {
            selectedCountry = CountryUtils.getByCode(this.getContext(), this.mPreferredCountries, this.mDefaultCountryCode);
        }
        if (!this.mHideNameCode) {
            if (this.mShowFullName) {
                if (!this.mHidePhoneCode) {
                    this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.country_full_name_and_phone_code, new Object[]{selectedCountry.getName().toUpperCase(), selectedCountry.getPhoneCode()}));
                } else {
                    this.mTvSelectedCountry.setText((CharSequence)selectedCountry.getName().toUpperCase());
                }
            } else if (!this.mHidePhoneCode) {
                this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.country_code_and_phone_code, new Object[]{selectedCountry.getIso().toUpperCase(), selectedCountry.getPhoneCode()}));
            } else {
                this.mTvSelectedCountry.setText((CharSequence)selectedCountry.getIso().toUpperCase());
            }
        } else {
            this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.phone_code, new Object[]{selectedCountry.getPhoneCode()}));
        }
        if (this.mOnCountryChangeListener != null) {
            this.mOnCountryChangeListener.onCountrySelected(selectedCountry);
        }
        this.mImvFlag.setImageResource(selectedCountry.getFlagDrawableResId());
        if (this.mIsHintEnabled) {
            this.setPhoneNumberHint();
        }
    }

    boolean isKeyboardAutoPopOnSearch() {
        return this.mKeyboardAutoPopOnSearch;
    }

    public void setKeyboardAutoPopOnSearch(boolean keyboardAutoPopOnSearch) {
        this.mKeyboardAutoPopOnSearch = keyboardAutoPopOnSearch;
    }

    public boolean isPhoneAutoFormatterEnabled() {
        return this.mIsEnablePhoneNumberWatcher;
    }

    public void enablePhoneAutoFormatter(boolean isEnable) {
        this.mIsEnablePhoneNumberWatcher = isEnable;
        if (isEnable) {
            if (this.mPhoneNumberWatcher == null) {
                this.mPhoneNumberWatcher = new PhoneNumberWatcher(this.getSelectedCountryNameCode());
            }
        } else {
            this.mPhoneNumberWatcher = null;
        }
    }

    private View.OnClickListener getCountryCodeHolderClickListener() {
        return this.mCountryCodeHolderClickListener;
    }

    void refreshPreferredCountries() {
        if (this.mCountryPreference == null || this.mCountryPreference.length() == 0) {
            this.mPreferredCountries = null;
        } else {
            ArrayList<Country> localCountryList = new ArrayList<Country>();
            for (String nameCode : this.mCountryPreference.split(",")) {
                Country country = CountryUtils.getByNameCodeFromCustomCountries(this.getContext(), this.mCustomMasterCountriesList, nameCode);
                if (country == null || this.isAlreadyInList(country, localCountryList)) continue;
                localCountryList.add(country);
            }
            this.mPreferredCountries = localCountryList.size() == 0 ? null : localCountryList;
        }
    }

    void refreshCustomMasterList() {
        if (this.mCustomMasterCountries == null || this.mCustomMasterCountries.length() == 0) {
            this.mCustomMasterCountriesList = null;
        } else {
            ArrayList<Country> localCountryList = new ArrayList<Country>();
            for (String nameCode : this.mCustomMasterCountries.split(",")) {
                Country country = CountryUtils.getByNameCodeFromAllCountries(this.getContext(), nameCode);
                if (country == null || this.isAlreadyInList(country, localCountryList)) continue;
                localCountryList.add(country);
            }
            this.mCustomMasterCountriesList = localCountryList.size() == 0 ? null : localCountryList;
        }
    }

    List<Country> getCustomCountries() {
        return this.mCustomMasterCountriesList;
    }

    List<Country> getCustomCountries(CountryCodePicker codePicker) {
        codePicker.refreshCustomMasterList();
        if (codePicker.getCustomCountries() != null && codePicker.getCustomCountries().size() > 0) {
            return codePicker.getCustomCountries();
        }
        return CountryUtils.getAllCountries(codePicker.getContext());
    }

    public void setCustomMasterCountriesList(List<Country> mCustomMasterCountriesList) {
        this.mCustomMasterCountriesList = mCustomMasterCountriesList;
    }

    public String getCustomMasterCountries() {
        return this.mCustomMasterCountries;
    }

    public List<Country> getPreferredCountries() {
        return this.mPreferredCountries;
    }

    public void setCustomMasterCountries(String customMasterCountries) {
        this.mCustomMasterCountries = customMasterCountries;
    }

    private boolean isAlreadyInList(Country country, List<Country> countryList) {
        if (country != null && countryList != null) {
            for (Country iterationCountry : countryList) {
                if (!iterationCountry.getIso().equalsIgnoreCase(country.getIso())) continue;
                return true;
            }
        }
        return false;
    }

    private String detectCarrierNumber(String fullNumber, Country country) {
        int indexOfCode;
        String carrierNumber = country == null || fullNumber == null ? fullNumber : ((indexOfCode = fullNumber.indexOf(country.getPhoneCode())) == -1 ? fullNumber : fullNumber.substring(indexOfCode + country.getPhoneCode().length()));
        return carrierNumber;
    }

    @Deprecated
    public void setDefaultCountryUsingPhoneCode(int defaultCountryCode) {
        Country defaultCountry = CountryUtils.getByCode(this.getContext(), this.mPreferredCountries, defaultCountryCode);
        if (defaultCountry != null) {
            this.mDefaultCountryCode = defaultCountryCode;
            this.setDefaultCountry(defaultCountry);
        }
    }

    public void setDefaultCountryUsingNameCode(String countryIso) {
        Country defaultCountry = CountryUtils.getByNameCodeFromAllCountries(this.getContext(), countryIso);
        if (defaultCountry != null) {
            this.mDefaultCountryNameCode = defaultCountry.getIso();
            this.setDefaultCountry(defaultCountry);
        }
    }

    public String getDefaultCountryCode() {
        return this.mDefaultCountry.getPhoneCode();
    }

    public int getDefaultCountryCodeAsInt() {
        int code = 0;
        try {
            code = Integer.parseInt(this.getDefaultCountryCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public String getDefaultCountryCodeWithPlus() {
        return this.getContext().getString(R.string.phone_code, new Object[]{this.getDefaultCountryCode()});
    }

    public String getDefaultCountryName() {
        return this.mDefaultCountry.getName();
    }

    public String getDefaultCountryNameCode() {
        return this.mDefaultCountry.getIso().toUpperCase();
    }

    public void resetToDefaultCountry() {
        this.setEmptyDefault();
    }

    public String getSelectedCountryCode() {
        return this.mSelectedCountry.getPhoneCode();
    }

    public String getSelectedCountryCodeWithPlus() {
        return this.getContext().getString(R.string.phone_code, new Object[]{this.getSelectedCountryCode()});
    }

    public int getSelectedCountryCodeAsInt() {
        int code = 0;
        try {
            code = Integer.parseInt(this.getSelectedCountryCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public String getSelectedCountryName() {
        return this.mSelectedCountry.getName();
    }

    public String getSelectedCountryNameCode() {
        return this.mSelectedCountry.getIso().toUpperCase();
    }

    public void setCountryForPhoneCode(int countryCode) {
        Country country = CountryUtils.getByCode(this.getContext(), this.mPreferredCountries, countryCode);
        if (country == null) {
            if (this.mDefaultCountry == null) {
                this.mDefaultCountry = CountryUtils.getByCode(this.getContext(), this.mPreferredCountries, this.mDefaultCountryCode);
            }
            this.setSelectedCountry(this.mDefaultCountry);
        } else {
            this.setSelectedCountry(country);
        }
    }

    public void setCountryForNameCode(String countryNameCode) {
        Country country = CountryUtils.getByNameCodeFromAllCountries(this.getContext(), countryNameCode);
        if (country == null) {
            if (this.mDefaultCountry == null) {
                this.mDefaultCountry = CountryUtils.getByCode(this.getContext(), this.mPreferredCountries, this.mDefaultCountryCode);
            }
            this.setSelectedCountry(this.mDefaultCountry);
        } else {
            this.setSelectedCountry(country);
        }
    }

    public void registerPhoneNumberTextView(TextView textView) {
        this.setRegisteredPhoneNumberTextView(textView);
    }

    public TextView getRegisteredPhoneNumberTextView() {
        return this.mRegisteredPhoneNumberTextView;
    }

    void setRegisteredPhoneNumberTextView(TextView phoneNumberTextView) {
        this.mRegisteredPhoneNumberTextView = phoneNumberTextView;
        if (this.mIsEnablePhoneNumberWatcher) {
            if (this.mPhoneNumberWatcher == null) {
                this.mPhoneNumberWatcher = new PhoneNumberWatcher(this.getDefaultCountryNameCode());
            }
            this.mRegisteredPhoneNumberTextView.addTextChangedListener((TextWatcher)this.mPhoneNumberWatcher);
        }
        if (this.mIsHintEnabled) {
            this.setPhoneNumberHint();
        }
    }

    public String getFullNumber() {
        String fullNumber;
        if (this.mRegisteredPhoneNumberTextView != null) {
            fullNumber = this.mSelectedCountry.getPhoneCode() + this.mRegisteredPhoneNumberTextView.getText().toString();
        } else {
            fullNumber = this.mSelectedCountry.getPhoneCode();
            Log.w((String)TAG, (String)this.getContext().getString(R.string.error_unregister_carrier_number));
        }
        return fullNumber;
    }

    public void setFullNumber(String fullNumber) {
        Country country = CountryUtils.getByNumber(this.getContext(), this.mPreferredCountries, fullNumber);
        this.setSelectedCountry(country);
        String carrierNumber = this.detectCarrierNumber(fullNumber, country);
        if (this.mRegisteredPhoneNumberTextView != null) {
            this.mRegisteredPhoneNumberTextView.setText((CharSequence)carrierNumber);
        } else {
            Log.w((String)TAG, (String)this.getContext().getString(R.string.error_unregister_carrier_number));
        }
    }

    public String getFullNumberWithPlus() {
        return this.getContext().getString(R.string.phone_code, new Object[]{this.getFullNumber()});
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getDefaultContentColor() {
        return 0;
    }

    public void setTextColor(int contentColor) {
        this.mTextColor = contentColor;
        this.mTvSelectedCountry.setTextColor(this.mTextColor);
        this.mImvArrow.setColorFilter(this.mTextColor, PorterDuff.Mode.SRC_IN);
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.mRlyHolder.setBackgroundColor(backgroundColor);
    }

    public int getDefaultBackgroundColor() {
        return 0;
    }

    public void setTextSize(int textSize) {
        if (textSize > 0) {
            this.mTvSelectedCountry.setTextSize(0, (float)textSize);
            this.setArrowSize(textSize);
            this.setFlagSize(textSize);
        }
    }

    private void setArrowSize(int arrowSize) {
        if (arrowSize > 0) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mImvArrow.getLayoutParams();
            params.width = arrowSize;
            params.height = arrowSize;
            this.mImvArrow.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public void hideNameCode(boolean hideNameCode) {
        this.mHideNameCode = hideNameCode;
        this.setSelectedCountry(this.mSelectedCountry);
    }

    public void setCountryPreference(String countryPreference) {
        this.mCountryPreference = countryPreference;
    }

    public void setTypeFace(Typeface typeFace) {
        this.mTypeFace = typeFace;
        try {
            this.mTvSelectedCountry.setTypeface(typeFace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTypeFace(String fontAssetPath) {
        try {
            Typeface typeFace;
            this.mTypeFace = typeFace = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)fontAssetPath);
            this.mTvSelectedCountry.setTypeface(typeFace);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Invalid fontPath. " + e.toString()));
        }
    }

    public void setTypeFace(Typeface typeFace, int style) {
        try {
            this.mTvSelectedCountry.setTypeface(typeFace, style);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Typeface getTypeFace() {
        return this.mTypeFace;
    }

    public void setOnCountryChangeListener(OnCountryChangeListener onCountryChangeListener) {
        this.mOnCountryChangeListener = onCountryChangeListener;
    }

    public void setFlagSize(int flagSize) {
        this.mImvFlag.getLayoutParams().height = flagSize;
        this.mImvFlag.requestLayout();
    }

    public void showFlag(boolean showFlag) {
        this.mShowFlag = showFlag;
        if (showFlag) {
            this.mLlyFlagHolder.setVisibility(0);
        } else {
            this.mLlyFlagHolder.setVisibility(8);
        }
    }

    public void showFullName(boolean showFullName) {
        this.mShowFullName = showFullName;
        this.setSelectedCountry(this.mSelectedCountry);
    }

    public boolean isSelectionDialogShowSearch() {
        return this.mSelectionDialogShowSearch;
    }

    public void setSelectionDialogShowSearch(boolean selectionDialogShowSearch) {
        this.mSelectionDialogShowSearch = selectionDialogShowSearch;
    }

    public boolean isClickable() {
        return this.mIsClickable;
    }

    public void setClickable(boolean isClickable) {
        this.mIsClickable = isClickable;
        if (!isClickable) {
            this.mRlyClickConsumer.setOnClickListener(null);
            this.mRlyClickConsumer.setClickable(false);
            this.mRlyClickConsumer.setEnabled(false);
        } else {
            this.mRlyClickConsumer.setOnClickListener(this.mCountryCodeHolderClickListener);
            this.mRlyClickConsumer.setClickable(true);
            this.mRlyClickConsumer.setEnabled(true);
        }
    }

    public boolean isHidePhoneCode() {
        return this.mHidePhoneCode;
    }

    public boolean isHintEnabled() {
        return this.mIsHintEnabled;
    }

    public void enableHint(boolean hintEnabled) {
        this.mIsHintEnabled = hintEnabled;
        if (this.mIsHintEnabled) {
            this.setPhoneNumberHint();
        }
    }

    public void setHidePhoneCode(boolean hidePhoneCode) {
        this.mHidePhoneCode = hidePhoneCode;
        if (!this.mHideNameCode) {
            if (this.mShowFullName) {
                if (!this.mHidePhoneCode) {
                    this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.country_full_name_and_phone_code, new Object[]{this.mSelectedCountry.getName().toUpperCase(), this.mSelectedCountry.getPhoneCode()}));
                } else {
                    this.mTvSelectedCountry.setText((CharSequence)this.mSelectedCountry.getName().toUpperCase());
                }
            } else if (!this.mHidePhoneCode) {
                this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.country_code_and_phone_code, new Object[]{this.mSelectedCountry.getIso().toUpperCase(), this.mSelectedCountry.getPhoneCode()}));
            } else {
                this.mTvSelectedCountry.setText((CharSequence)this.mSelectedCountry.getIso().toUpperCase());
            }
        } else {
            this.mTvSelectedCountry.setText((CharSequence)this.getContext().getString(R.string.phone_code, new Object[]{this.mSelectedCountry.getPhoneCode()}));
        }
    }

    private void setPhoneNumberHint() {
        Phonenumber.PhoneNumber phoneNumber;
        if (this.mRegisteredPhoneNumberTextView != null && this.mSelectedCountry != null && this.mSelectedCountry.getIso() != null && (phoneNumber = this.mPhoneUtil.getExampleNumberForType(this.mSelectedCountry.getIso().toUpperCase(), PhoneNumberUtil.PhoneNumberType.MOBILE)) != null) {
            this.mRegisteredPhoneNumberTextView.setHint((CharSequence)this.mPhoneUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL));
        }
    }

    public String getNumber() {
        Phonenumber.PhoneNumber phoneNumber = this.getPhoneNumber();
        if (phoneNumber == null) {
            return null;
        }
        if (this.mRegisteredPhoneNumberTextView == null) {
            Log.w((String)TAG, (String)this.getContext().getString(R.string.error_unregister_carrier_number));
            return null;
        }
        return this.mPhoneUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
    }

    public Phonenumber.PhoneNumber getPhoneNumber() {
        try {
            String iso = null;
            if (this.mSelectedCountry != null) {
                iso = this.mSelectedCountry.getIso().toUpperCase();
            }
            if (this.mRegisteredPhoneNumberTextView == null) {
                Log.w((String)TAG, (String)this.getContext().getString(R.string.error_unregister_carrier_number));
                return null;
            }
            return this.mPhoneUtil.parse(this.mRegisteredPhoneNumberTextView.getText().toString(), iso);
        }
        catch (NumberParseException ignored) {
            return null;
        }
    }

    public boolean isValid() {
        Phonenumber.PhoneNumber phoneNumber = this.getPhoneNumber();
        return phoneNumber != null && this.mPhoneUtil.isValidNumber(phoneNumber);
    }

    public void setPhoneNumberInputValidityListener(PhoneNumberInputValidityListener listener) {
        this.mPhoneNumberInputValidityListener = listener;
    }

    private void setDefaultCountryFlagAndCode() {
        TelephonyManager telManager = (TelephonyManager)this.getContext().getSystemService("phone");
        String simCountryIso = telManager.getSimCountryIso();
        if (simCountryIso != null && !simCountryIso.isEmpty()) {
            this.setEmptyDefault(simCountryIso);
            Log.d((String)TAG, (String)("simCountryIso = " + simCountryIso));
        } else {
            String iso = telManager.getNetworkCountryIso();
            if (iso != null && !iso.isEmpty()) {
                this.setEmptyDefault(iso);
                Log.d((String)TAG, (String)("isoNetwork = " + iso));
            } else {
                this.enableSetCountryByTimeZone(true);
            }
        }
    }

    private void setEmptyDefault() {
        this.setEmptyDefault(null);
    }

    private void setEmptyDefault(String countryCode) {
        if (countryCode == null || countryCode.isEmpty()) {
            countryCode = this.mDefaultCountryNameCode != null && !this.mDefaultCountryNameCode.isEmpty() ? this.mDefaultCountryNameCode : (this.DEFAULT_COUNTRY != null && !this.DEFAULT_COUNTRY.isEmpty() ? this.DEFAULT_COUNTRY : DEFAULT_ISO_COUNTRY);
        }
        if (this.mIsEnablePhoneNumberWatcher && this.mPhoneNumberWatcher == null) {
            this.mPhoneNumberWatcher = new PhoneNumberWatcher(countryCode);
        }
        this.setDefaultCountryUsingNameCode(countryCode);
        this.setSelectedCountry(this.getDefaultCountry());
    }

    public void enableSetCountryByTimeZone(boolean isEnabled) {
        if (isEnabled) {
            if (this.mDefaultCountryNameCode != null && !this.mDefaultCountryNameCode.isEmpty()) {
                return;
            }
            if (this.mRegisteredPhoneNumberTextView != null) {
                return;
            }
            if (this.mSetCountryByTimeZone) {
                TimeZone tz = TimeZone.getDefault();
                Log.d((String)TAG, (String)("tz.getID() = " + tz.getID()));
                List<String> countryIsos = CountryUtils.getCountryIsoByTimeZone(this.getContext(), tz.getID());
                if (countryIsos != null) {
                    this.setDefaultCountryUsingNameCode(countryIsos.get(0));
                    this.setSelectedCountry(this.getDefaultCountry());
                } else {
                    this.setEmptyDefault();
                }
            }
        }
        this.mSetCountryByTimeZone = isEnabled;
    }

    private class PhoneNumberWatcher
    extends PhoneNumberFormattingTextWatcher {
        private boolean lastValidity;

        public PhoneNumberWatcher() {
        }

        @TargetApi(value=21)
        public PhoneNumberWatcher(String countryCode) {
            super(countryCode);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onTextChanged(CharSequence s, int start, int before, int count) {
            super.onTextChanged(s, start, before, count);
            try {
                String iso = null;
                if (CountryCodePicker.this.mSelectedCountry != null) {
                    iso = CountryCodePicker.this.mSelectedCountry.getPhoneCode().toUpperCase();
                }
                Phonenumber.PhoneNumber phoneNumber = CountryCodePicker.this.mPhoneUtil.parse(s.toString(), iso);
                iso = CountryCodePicker.this.mPhoneUtil.getRegionCodeForNumber(phoneNumber);
                if (iso == null) {
                    // empty if block
                }
            }
            catch (NumberParseException iso) {
                // empty catch block
            }
            if (CountryCodePicker.this.mPhoneNumberInputValidityListener != null) {
                boolean validity = CountryCodePicker.this.isValid();
                if (validity != this.lastValidity) {
                    CountryCodePicker.this.mPhoneNumberInputValidityListener.onFinish(CountryCodePicker.this, validity);
                }
                this.lastValidity = validity;
            }
        }
    }

    public static interface PhoneNumberInputValidityListener {
        public void onFinish(CountryCodePicker var1, boolean var2);
    }

    public static interface OnCountryChangeListener {
        public void onCountrySelected(Country var1);
    }
}

