/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.content.Context;
import android.util.Log;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.CountryUtils;
import com.rilixtech.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class Country {
    private static String TAG = Country.class.getSimpleName();
    private String nameCode;
    private String phoneCode;
    private String name;

    public Country() {
    }

    public Country(String nameCode, String phoneCode, String name) {
        this.nameCode = nameCode;
        this.phoneCode = phoneCode;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Country> readXMLofCountries(Context context) {
        ArrayList<Country> countries = new ArrayList<Country>();
        try {
            XmlPullParserFactory xmlFactoryObject = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlFactoryObject.newPullParser();
            InputStream ins = context.getResources().openRawResource(R.raw.countries);
            xmlPullParser.setInput(ins, null);
            int event = xmlPullParser.getEventType();
            while (event != 1) {
                String name = xmlPullParser.getName();
                switch (event) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (!name.equals("country")) break;
                        Country country = new Country();
                        country.setNameCode(xmlPullParser.getAttributeValue(null, "code").toUpperCase());
                        country.setPhoneCode(xmlPullParser.getAttributeValue(null, "phoneCode"));
                        country.setName(xmlPullParser.getAttributeValue(null, "name"));
                        countries.add(country);
                    }
                }
                event = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return countries;
    }

    private static Country getCountryForCode(Context context, List<Country> preferredCountries, String code) {
        if (preferredCountries != null && !preferredCountries.isEmpty()) {
            for (Country country : preferredCountries) {
                if (!country.getPhoneCode().equals(code)) continue;
                return country;
            }
        }
        for (Country country : CountryUtils.getLibraryMasterCountries(context)) {
            if (!country.getPhoneCode().equals(code)) continue;
            return country;
        }
        return null;
    }

    public static List<Country> getCustomMasterCountryList(CountryCodePicker codePicker) {
        codePicker.refreshCustomMasterList();
        if (codePicker.getCustomMasterCountriesList() != null && codePicker.getCustomMasterCountriesList().size() > 0) {
            return codePicker.getCustomMasterCountriesList();
        }
        return CountryUtils.getLibraryMasterCountries(codePicker.getContext());
    }

    public static Country getCountryForNameCodeFromCustomMasterList(Context context, List<Country> customMasterCountriesList, String nameCode) {
        if (customMasterCountriesList == null || customMasterCountriesList.size() == 0) {
            return Country.getCountryForNameCodeFromLibraryMasterList(context, nameCode);
        }
        for (Country country : customMasterCountriesList) {
            if (!country.getNameCode().equalsIgnoreCase(nameCode)) continue;
            return country;
        }
        return null;
    }

    public static Country getCountryForNameCodeFromLibraryMasterList(Context context, String nameCode) {
        List<Country> countries = CountryUtils.getLibraryMasterCountries(context);
        for (Country country : countries) {
            if (!country.getNameCode().equalsIgnoreCase(nameCode)) continue;
            return country;
        }
        return null;
    }

    public static Country getCountryForNameCodeTrial(String nameCode, Context context) {
        List<Country> countries = Country.readXMLofCountries(context);
        for (Country country : countries) {
            if (!country.getNameCode().equalsIgnoreCase(nameCode)) continue;
            return country;
        }
        return null;
    }

    static Country getCountryForCode(Context context, List<Country> preferredCountries, int code) {
        return Country.getCountryForCode(context, preferredCountries, code + "");
    }

    static Country getCountryForNumber(Context context, List<Country> preferredCountries, String fullNumber) {
        if (fullNumber.length() != 0) {
            int firstDigit = fullNumber.charAt(0) == '+' ? 1 : 0;
            for (int i = firstDigit; i < firstDigit + 4; ++i) {
                String code = fullNumber.substring(firstDigit, i);
                Country country = Country.getCountryForCode(context, preferredCountries, code);
                if (country == null) continue;
                return country;
            }
        }
        return null;
    }

    public int getFlagID() {
        return CountryUtils.getFlagResID(this);
    }

    public String getNameCode() {
        return this.nameCode;
    }

    public void setNameCode(String nameCode) {
        this.nameCode = nameCode;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void log() {
        try {
            Log.d((String)TAG, (String)("Country->" + this.nameCode + ":" + this.phoneCode + ":" + this.name));
        }
        catch (NullPointerException ex) {
            Log.d((String)TAG, (String)"Null");
        }
    }

    public String logString() {
        return this.nameCode.toUpperCase() + " +" + this.phoneCode + "(" + this.name + ")";
    }

    public boolean isEligibleForQuery(String query) {
        query = query.toLowerCase();
        return this.getName().toLowerCase().contains(query) || this.getNameCode().toLowerCase().contains(query) || this.getPhoneCode().toLowerCase().contains(query);
    }
}

