/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import shadow.org.apache.logging.log4j.Logger;
import shadow.org.apache.logging.log4j.core.appender.rolling.action.Duration;
import shadow.org.apache.logging.log4j.core.appender.rolling.action.IfAll;
import shadow.org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import shadow.org.apache.logging.log4j.core.config.plugins.Plugin;
import shadow.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import shadow.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import shadow.org.apache.logging.log4j.core.util.Clock;
import shadow.org.apache.logging.log4j.core.util.ClockFactory;
import shadow.org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="IfLastModified", category="Core", printObject=true)
public final class IfLastModified
implements PathCondition {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Clock CLOCK = ClockFactory.getClock();
    private final Duration age;
    private final PathCondition[] nestedConditions;

    private IfLastModified(Duration age, PathCondition[] nestedConditions) {
        this.age = Objects.requireNonNull(age, "age");
        this.nestedConditions = PathCondition.copy(nestedConditions);
    }

    public Duration getAge() {
        return this.age;
    }

    public List<PathCondition> getNestedConditions() {
        return Collections.unmodifiableList(Arrays.asList(this.nestedConditions));
    }

    @Override
    public boolean accept(Path basePath, Path relativePath, BasicFileAttributes attrs) {
        FileTime fileTime = attrs.lastModifiedTime();
        long millis = fileTime.toMillis();
        long ageMillis = CLOCK.currentTimeMillis() - millis;
        boolean result = ageMillis >= this.age.toMillis();
        String match = result ? ">=" : "<";
        String accept = result ? "ACCEPTED" : "REJECTED";
        LOGGER.trace("IfLastModified {}: {} ageMillis '{}' {} '{}'", (Object)accept, (Object)relativePath, (Object)ageMillis, (Object)match, (Object)this.age);
        if (result) {
            return IfAll.accept(this.nestedConditions, basePath, relativePath, attrs);
        }
        return result;
    }

    @Override
    public void beforeFileTreeWalk() {
        IfAll.beforeFileTreeWalk(this.nestedConditions);
    }

    @PluginFactory
    public static IfLastModified createAgeCondition(@PluginAttribute(value="age") Duration age, PathCondition ... nestedConditions) {
        return new IfLastModified(age, nestedConditions);
    }

    public String toString() {
        String nested = this.nestedConditions.length == 0 ? "" : " AND " + Arrays.toString(this.nestedConditions);
        return "IfLastModified(age=" + this.age + nested + ")";
    }
}

