/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish.plugin.dep.oauth.signpost.signature;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import shadow.com.gradle.publish.plugin.dep.oauth.signpost.OAuth;
import shadow.com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthMessageSignerException;
import shadow.com.gradle.publish.plugin.dep.oauth.signpost.http.HttpParameters;
import shadow.com.gradle.publish.plugin.dep.oauth.signpost.http.HttpRequest;

public class SignatureBaseString {
    private HttpRequest request;
    private HttpParameters requestParameters;

    public SignatureBaseString(HttpRequest request, HttpParameters requestParameters) {
        this.request = request;
        this.requestParameters = requestParameters;
    }

    public String generate() throws OAuthMessageSignerException {
        try {
            String normalizedUrl = this.normalizeRequestUrl();
            String normalizedParams = this.normalizeRequestParameters();
            return this.request.getMethod() + '&' + OAuth.percentEncode(normalizedUrl) + '&' + OAuth.percentEncode(normalizedParams);
        }
        catch (Exception e) {
            throw new OAuthMessageSignerException(e);
        }
    }

    public String normalizeRequestUrl() throws URISyntaxException {
        String path;
        int index;
        boolean dropPort;
        URI uri = new URI(this.request.getRequestUrl());
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    public String normalizeRequestParameters() throws IOException {
        if (this.requestParameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = this.requestParameters.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String param = iter.next();
            if (!"oauth_signature".equals(param) && !"realm".equals(param)) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(this.requestParameters.getAsQueryString(param, false));
            }
            ++i;
        }
        return sb.toString();
    }
}

