/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import shadow.org.apache.tools.ant.util.LayoutPreservingProperties;

public class PropertiesStore {
    static LayoutPreservingProperties fromFile(File file) throws IOException {
        LayoutPreservingProperties properties = new LayoutPreservingProperties();
        properties.setRemoveComments(true);
        if (file.exists()) {
            try (FileInputStream in = null;){
                in = new FileInputStream(file);
                properties.load(in);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void append(File propertiesFile, Map<String, String> props, String message) throws IOException {
        FileOutputStream out = null;
        try {
            LayoutPreservingProperties properties = PropertiesStore.fromFile(propertiesFile);
            out = new FileOutputStream(propertiesFile);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
            properties.store(out, message);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static Properties gradleProperties(Project project) {
        Properties properties = new Properties();
        if (null != project.getProperties()) {
            for (Map.Entry entry : project.getProperties().entrySet()) {
                if (null == entry.getValue()) continue;
                properties.setProperty((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return properties;
    }

    public static Properties all(Project project) {
        return PropertiesStore.join(PropertiesStore.gradleProperties(project), System.getProperties());
    }

    public static Properties join(Properties ... props) {
        Properties result = new Properties();
        for (Properties properties : props) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                result.setProperty(key, properties.getProperty(key));
            }
        }
        return result;
    }
}

