/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import shadow.com.gradle.publish.MavenCoordinates;
import shadow.com.gradle.publish.PluginBundleExtension;
import shadow.com.gradle.publish.PluginConfig;

public class GroupId {
    public static final String GROUP_PREFIX = "gradle.plugin";

    private static boolean hasText(String src) {
        return src != null && !src.trim().isEmpty();
    }

    private static String prefix(String group) {
        return "gradle.plugin." + group;
    }

    public static String createGroupId(Project project, PluginBundleExtension bundleConfig) {
        String mavenGroup;
        MavenCoordinates coords = bundleConfig.getMavenCoordinates();
        String string = mavenGroup = coords == null ? null : coords.getGroupId();
        if (GroupId.hasText(mavenGroup)) {
            return mavenGroup;
        }
        String projectGroup = project.getGroup().toString();
        if (GroupId.hasText(projectGroup)) {
            return GroupId.prefix(projectGroup);
        }
        NamedDomainObjectContainer<PluginConfig> plugins = bundleConfig.getPlugins();
        if (plugins.size() == 1) {
            return GroupId.prefix(((PluginConfig)plugins.getAsMap().values().iterator().next()).getId());
        }
        return GroupId.findCommonPrefix(plugins);
    }

    private static String findCommonPrefix(Collection<PluginConfig> plugins) {
        ArrayList<List<String>> chunks = new ArrayList<List<String>>();
        for (PluginConfig plugin : plugins) {
            chunks.add(Arrays.asList(plugin.getId().split("\\.")));
        }
        StringBuilder commonPrefix = new StringBuilder();
        block1: for (int i = 0; i < ((List)chunks.get(0)).size(); ++i) {
            String nextChunk = (String)((List)chunks.get(0)).get(i);
            for (int j = 1; j < chunks.size(); ++j) {
                if (((List)chunks.get(j)).size() < i + 1 || !((String)((List)chunks.get(j)).get(i)).equals(nextChunk)) break block1;
            }
            if (commonPrefix.length() > 0) {
                commonPrefix.append(".");
            }
            commonPrefix.append(nextChunk);
        }
        if (commonPrefix.length() == 0) {
            throw new IllegalArgumentException("No project group, maven group id or common plugin id prefix found.\nPlease set one of the above to publish your plugin bundle.");
        }
        return GroupId.prefix(commonPrefix.toString());
    }
}

