/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant;

import java.util.ArrayList;
import java.util.List;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.Task;

public class TaskConfigurationChecker {
    private List<String> errors = new ArrayList<String>();
    private final Task task;

    public TaskConfigurationChecker(Task task) {
        this.task = task;
    }

    public void assertConfig(boolean condition, String errormessage) {
        if (!condition) {
            this.errors.add(errormessage);
        }
    }

    public void fail(String errormessage) {
        this.errors.add(errormessage);
    }

    public void checkErrors() throws BuildException {
        if (!this.errors.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Configurationerror on <");
            sb.append(this.task.getTaskName());
            sb.append(">:");
            sb.append(System.getProperty("line.separator"));
            for (String msg : this.errors) {
                sb.append("- ");
                sb.append(msg);
                sb.append(System.getProperty("line.separator"));
            }
            throw new BuildException(sb.toString(), this.task.getLocation());
        }
    }
}

