/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import shadow.org.apache.tools.ant.AntClassLoader;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.taskdefs.Java;
import shadow.org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import shadow.org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import shadow.org.apache.tools.ant.types.Path;

public class JonasDeploymentTool
extends GenericDeploymentTool {
    protected static final String EJB_JAR_1_1_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    protected static final String EJB_JAR_2_0_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    protected static final String JONAS_EJB_JAR_2_4_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 2.4//EN";
    protected static final String JONAS_EJB_JAR_2_5_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 2.5//EN";
    protected static final String RMI_ORB = "RMI";
    protected static final String JEREMIE_ORB = "JEREMIE";
    protected static final String DAVID_ORB = "DAVID";
    protected static final String EJB_JAR_1_1_DTD = "ejb-jar_1_1.dtd";
    protected static final String EJB_JAR_2_0_DTD = "ejb-jar_2_0.dtd";
    protected static final String JONAS_EJB_JAR_2_4_DTD = "jonas-ejb-jar_2_4.dtd";
    protected static final String JONAS_EJB_JAR_2_5_DTD = "jonas-ejb-jar_2_5.dtd";
    protected static final String JONAS_DD = "jonas-ejb-jar.xml";
    protected static final String GENIC_CLASS = "org.objectweb.jonas_ejb.genic.GenIC";
    protected static final String OLD_GENIC_CLASS_1 = "org.objectweb.jonas_ejb.tools.GenWholeIC";
    protected static final String OLD_GENIC_CLASS_2 = "org.objectweb.jonas_ejb.tools.GenIC";
    private String descriptorName;
    private String jonasDescriptorName;
    private File outputdir;
    private boolean keepgenerated = false;
    private boolean nocompil = false;
    private boolean novalidation = false;
    private String javac;
    private String javacopts;
    private String rmicopts;
    private boolean secpropag = false;
    private boolean verbose = false;
    private String additionalargs;
    private File jonasroot;
    private boolean keepgeneric = false;
    private String suffix = ".jar";
    private String orb;
    private boolean nogenic = false;

    public void setKeepgenerated(boolean aBoolean) {
        this.keepgenerated = aBoolean;
    }

    public void setAdditionalargs(String aString) {
        this.additionalargs = aString;
    }

    public void setNocompil(boolean aBoolean) {
        this.nocompil = aBoolean;
    }

    public void setNovalidation(boolean aBoolean) {
        this.novalidation = aBoolean;
    }

    public void setJavac(String aString) {
        this.javac = aString;
    }

    public void setJavacopts(String aString) {
        this.javacopts = aString;
    }

    public void setRmicopts(String aString) {
        this.rmicopts = aString;
    }

    public void setSecpropag(boolean aBoolean) {
        this.secpropag = aBoolean;
    }

    public void setVerbose(boolean aBoolean) {
        this.verbose = aBoolean;
    }

    public void setJonasroot(File aFile) {
        this.jonasroot = aFile;
    }

    public void setKeepgeneric(boolean aBoolean) {
        this.keepgeneric = aBoolean;
    }

    public void setJarsuffix(String aString) {
        this.suffix = aString;
    }

    public void setOrb(String aString) {
        this.orb = aString;
    }

    public void setNogenic(boolean aBoolean) {
        this.nogenic = aBoolean;
    }

    public void processDescriptor(String aDescriptorName, SAXParser saxParser) {
        this.descriptorName = aDescriptorName;
        this.log("JOnAS Deployment Tool processing: " + this.descriptorName, 3);
        super.processDescriptor(this.descriptorName, saxParser);
        if (this.outputdir != null) {
            this.log("Deleting temp output directory '" + this.outputdir + "'.", 3);
            this.deleteAllFiles(this.outputdir);
        }
    }

    protected void writeJar(String baseName, File jarfile, Hashtable ejbFiles, String publicId) throws BuildException {
        File genericJarFile = super.getVendorOutputJarFile(baseName);
        super.writeJar(baseName, genericJarFile, ejbFiles, publicId);
        this.addGenICGeneratedFiles(genericJarFile, ejbFiles);
        super.writeJar(baseName, this.getVendorOutputJarFile(baseName), ejbFiles, publicId);
        if (!this.keepgeneric) {
            this.log("Deleting generic JAR " + genericJarFile.toString(), 3);
            genericJarFile.delete();
        }
    }

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
        this.jonasDescriptorName = this.getJonasDescriptorName();
        File jonasDD = new File(this.getConfig().descriptorDir, this.jonasDescriptorName);
        if (jonasDD.exists()) {
            ejbFiles.put("META-INF/jonas-ejb-jar.xml", jonasDD);
        } else {
            this.log("Unable to locate the JOnAS deployment descriptor. It was expected to be in: " + jonasDD.getPath() + ".", 1);
        }
    }

    protected File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), baseName + this.suffix);
    }

    private String getJonasDescriptorName() {
        String fileName;
        String path;
        boolean jonasConvention = false;
        int startOfFileName = this.descriptorName.lastIndexOf(File.separatorChar);
        if (startOfFileName != -1) {
            path = this.descriptorName.substring(0, startOfFileName + 1);
            fileName = this.descriptorName.substring(startOfFileName + 1);
        } else {
            path = "";
            fileName = this.descriptorName;
        }
        if (fileName.startsWith("ejb-jar.xml")) {
            return path + JONAS_DD;
        }
        int endOfBaseName = this.descriptorName.indexOf(this.getConfig().baseNameTerminator, startOfFileName);
        if (endOfBaseName < 0) {
            endOfBaseName = this.descriptorName.lastIndexOf(46) - 1;
            if (endOfBaseName < 0) {
                endOfBaseName = this.descriptorName.length() - 1;
            }
            jonasConvention = true;
        }
        String baseName = this.descriptorName.substring(startOfFileName + 1, endOfBaseName + 1);
        String remainder = this.descriptorName.substring(endOfBaseName + 1);
        String jonasDN = jonasConvention ? path + "jonas-" + baseName + ".xml" : path + baseName + "jonas-" + remainder;
        this.log("Standard EJB descriptor name: " + this.descriptorName, 3);
        this.log("JOnAS-specific descriptor name: " + jonasDN, 3);
        return jonasDN;
    }

    protected String getJarBaseName(String descriptorFileName) {
        String aCanonicalDescriptor;
        int lastSeparatorIndex;
        int endOfBaseName;
        String baseName = null;
        if (this.getConfig().namingScheme.getValue().equals("descriptor") && descriptorFileName.indexOf(this.getConfig().baseNameTerminator) == -1 && (endOfBaseName = (lastSeparatorIndex = (aCanonicalDescriptor = descriptorFileName.replace('\\', '/')).lastIndexOf(47)) != -1 ? descriptorFileName.indexOf(".xml", lastSeparatorIndex) : descriptorFileName.indexOf(".xml")) != -1) {
            baseName = descriptorFileName.substring(0, endOfBaseName);
        }
        if (baseName == null) {
            baseName = super.getJarBaseName(descriptorFileName);
        }
        this.log("JAR base name: " + baseName, 3);
        return baseName;
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
        handler.registerDTD(EJB_JAR_1_1_PUBLIC_ID, this.jonasroot + File.separator + "xml" + File.separator + EJB_JAR_1_1_DTD);
        handler.registerDTD(EJB_JAR_2_0_PUBLIC_ID, this.jonasroot + File.separator + "xml" + File.separator + EJB_JAR_2_0_DTD);
        handler.registerDTD(JONAS_EJB_JAR_2_4_PUBLIC_ID, this.jonasroot + File.separator + "xml" + File.separator + JONAS_EJB_JAR_2_4_DTD);
        handler.registerDTD(JONAS_EJB_JAR_2_5_PUBLIC_ID, this.jonasroot + File.separator + "xml" + File.separator + JONAS_EJB_JAR_2_5_DTD);
    }

    private void addGenICGeneratedFiles(File genericJarFile, Hashtable ejbFiles) {
        Java genicTask = null;
        String genicClass = null;
        if (this.nogenic) {
            return;
        }
        genicTask = new Java(this.getTask());
        genicTask.setTaskName("genic");
        genicTask.setFork(true);
        genicTask.createJvmarg().setValue("-Dinstall.root=" + this.jonasroot);
        String jonasConfigDir = this.jonasroot + File.separator + "config";
        File javaPolicyFile = new File(jonasConfigDir, "java.policy");
        if (javaPolicyFile.exists()) {
            genicTask.createJvmarg().setValue("-Djava.security.policy=" + javaPolicyFile.toString());
        }
        try {
            this.outputdir = this.createTempDir();
        }
        catch (IOException aIOException) {
            String msg = "Cannot create temp dir: " + aIOException.getMessage();
            throw new BuildException(msg, aIOException);
        }
        this.log("Using temporary output directory: " + this.outputdir, 3);
        genicTask.createArg().setValue("-d");
        genicTask.createArg().setFile(this.outputdir);
        Enumeration keys = ejbFiles.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            File f = new File(this.outputdir + File.separator + key);
            f.getParentFile().mkdirs();
        }
        this.log("Worked around a bug of GenIC 2.5.", 3);
        Path classpath = this.getCombinedClasspath();
        if (classpath == null) {
            classpath = new Path(this.getTask().getProject());
        }
        classpath.append(new Path(classpath.getProject(), jonasConfigDir));
        classpath.append(new Path(classpath.getProject(), this.outputdir.toString()));
        if (this.orb != null) {
            String orbJar = this.jonasroot + File.separator + "lib" + File.separator + this.orb + "_jonas.jar";
            classpath.append(new Path(classpath.getProject(), orbJar));
        }
        this.log("Using classpath: " + classpath.toString(), 3);
        genicTask.setClasspath(classpath);
        genicClass = this.getGenicClassName(classpath);
        if (genicClass == null) {
            this.log("Cannot find GenIC class in classpath.", 0);
            throw new BuildException("GenIC class not found, please check the classpath.");
        }
        this.log("Using '" + genicClass + "' GenIC class.", 3);
        genicTask.setClassname(genicClass);
        if (this.keepgenerated) {
            genicTask.createArg().setValue("-keepgenerated");
        }
        if (this.nocompil) {
            genicTask.createArg().setValue("-nocompil");
        }
        if (this.novalidation) {
            genicTask.createArg().setValue("-novalidation");
        }
        if (this.javac != null) {
            genicTask.createArg().setValue("-javac");
            genicTask.createArg().setLine(this.javac);
        }
        if (this.javacopts != null && !this.javacopts.equals("")) {
            genicTask.createArg().setValue("-javacopts");
            genicTask.createArg().setLine(this.javacopts);
        }
        if (this.rmicopts != null && !this.rmicopts.equals("")) {
            genicTask.createArg().setValue("-rmicopts");
            genicTask.createArg().setLine(this.rmicopts);
        }
        if (this.secpropag) {
            genicTask.createArg().setValue("-secpropag");
        }
        if (this.verbose) {
            genicTask.createArg().setValue("-verbose");
        }
        if (this.additionalargs != null) {
            genicTask.createArg().setValue(this.additionalargs);
        }
        genicTask.createArg().setValue("-noaddinjar");
        genicTask.createArg().setValue(genericJarFile.getPath());
        this.log("Calling " + genicClass + " for " + this.getConfig().descriptorDir + File.separator + this.descriptorName + ".", 3);
        if (genicTask.executeJava() != 0) {
            this.log("Deleting temp output directory '" + this.outputdir + "'.", 3);
            this.deleteAllFiles(this.outputdir);
            if (!this.keepgeneric) {
                this.log("Deleting generic JAR " + genericJarFile.toString(), 3);
                genericJarFile.delete();
            }
            throw new BuildException("GenIC reported an error.");
        }
        this.addAllFiles(this.outputdir, "", ejbFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getGenicClassName(Path classpath) {
        String string;
        this.log("Looking for GenIC class in classpath: " + classpath.toString(), 3);
        AntClassLoader cl = null;
        cl = classpath.getProject().createClassLoader(classpath);
        try {
            cl.loadClass(GENIC_CLASS);
            this.log("Found GenIC class 'org.objectweb.jonas_ejb.genic.GenIC' in classpath.", 3);
            string = GENIC_CLASS;
        }
        catch (ClassNotFoundException cnf1222) {
            String cnf1222;
            this.log("GenIC class 'org.objectweb.jonas_ejb.genic.GenIC' not found in classpath.", 3);
            try {
                cl.loadClass(OLD_GENIC_CLASS_1);
                this.log("Found GenIC class 'org.objectweb.jonas_ejb.tools.GenWholeIC' in classpath.", 3);
                cnf1222 = OLD_GENIC_CLASS_1;
            }
            catch (ClassNotFoundException cnf2222) {
                String cnf2222;
                this.log("GenIC class 'org.objectweb.jonas_ejb.tools.GenWholeIC' not found in classpath.", 3);
                try {
                    cl.loadClass(OLD_GENIC_CLASS_2);
                    this.log("Found GenIC class 'org.objectweb.jonas_ejb.tools.GenIC' in classpath.", 3);
                    cnf2222 = OLD_GENIC_CLASS_2;
                }
                catch (ClassNotFoundException cnf3) {
                    try {
                        this.log("GenIC class 'org.objectweb.jonas_ejb.tools.GenIC' not found in classpath.", 3);
                        Object var5_12 = null;
                        if (cl == null) return null;
                        cl.cleanup();
                        return null;
                    }
                    catch (Throwable throwable) {
                        Object var5_13 = null;
                        if (cl == null) throw throwable;
                        cl.cleanup();
                        throw throwable;
                    }
                }
                Object var5_11 = null;
                if (cl == null) return cnf2222;
                cl.cleanup();
                return cnf2222;
            }
            Object var5_10 = null;
            if (cl == null) return cnf1222;
            cl.cleanup();
            return cnf1222;
        }
        Object var5_9 = null;
        if (cl == null) return string;
        cl.cleanup();
        return string;
    }

    protected void checkConfiguration(String descriptorFileName, SAXParser saxParser) throws BuildException {
        if (this.jonasroot == null) {
            throw new BuildException("The jonasroot attribut is not set.");
        }
        if (!this.jonasroot.isDirectory()) {
            throw new BuildException("The jonasroot attribut '" + this.jonasroot + "' is not a valid directory.");
        }
        if (!(this.orb == null || this.orb.equals(RMI_ORB) || this.orb.equals(JEREMIE_ORB) || this.orb.equals(DAVID_ORB))) {
            throw new BuildException("The orb attribut '" + this.orb + "' is not valid (must be either " + RMI_ORB + ", " + JEREMIE_ORB + " or " + DAVID_ORB + ").");
        }
        if (this.additionalargs != null && this.additionalargs.equals("")) {
            throw new BuildException("Empty additionalargs attribut.");
        }
        if (this.javac != null && this.javac.equals("")) {
            throw new BuildException("Empty javac attribut.");
        }
    }

    private File createTempDir() throws IOException {
        File tmpDir = File.createTempFile("genic", null, null);
        tmpDir.delete();
        if (!tmpDir.mkdir()) {
            throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
        }
        return tmpDir;
    }

    private void deleteAllFiles(File aFile) {
        if (aFile.isDirectory()) {
            File[] someFiles = aFile.listFiles();
            for (int i = 0; i < someFiles.length; ++i) {
                this.deleteAllFiles(someFiles[i]);
            }
        }
        aFile.delete();
    }

    private void addAllFiles(File file, String rootDir, Hashtable hashtable) {
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String newRootDir = rootDir.length() > 0 ? rootDir + File.separator + files[i].getName() : files[i].getName();
                this.addAllFiles(files[i], newRootDir, hashtable);
            }
        } else {
            hashtable.put(rootDir, file);
        }
    }
}

