/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.types.resources;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.Project;
import shadow.org.apache.tools.ant.types.DataType;
import shadow.org.apache.tools.ant.types.Resource;
import shadow.org.apache.tools.ant.types.ResourceCollection;
import shadow.org.apache.tools.ant.types.resources.BaseResourceCollectionWrapper;
import shadow.org.apache.tools.ant.types.resources.FailFast;
import shadow.org.apache.tools.ant.types.resources.comparators.DelegatedResourceComparator;
import shadow.org.apache.tools.ant.types.resources.comparators.ResourceComparator;
import shadow.org.apache.tools.ant.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sort
extends BaseResourceCollectionWrapper {
    private DelegatedResourceComparator comp = new DelegatedResourceComparator();

    @Override
    protected synchronized Collection<Resource> getCollection() {
        ResourceCollection rc = this.getResourceCollection();
        Iterator<Resource> iter = rc.iterator();
        if (!iter.hasNext()) {
            return Collections.emptySet();
        }
        List result = (List)CollectionUtils.asCollection(iter);
        Collections.sort(result, this.comp);
        return result;
    }

    public synchronized void add(ResourceComparator c) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.comp.add(c);
        FailFast.invalidate(this);
        this.setChecked(false);
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        super.dieOnCircularReference(stk, p);
        if (!this.isReference()) {
            DataType.pushAndInvokeCircularReferenceCheck(this.comp, stk, p);
            this.setChecked(true);
        }
    }
}

