/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.osm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tags
implements Iterable<String>,
Externalizable {
    private List<String> keys;
    private List<String> values;

    private void createArrays() {
        if (!this.hasArrays()) {
            this.keys = new ArrayList<String>();
            this.values = new ArrayList<String>();
        }
    }

    private boolean hasArrays() {
        return this.keys != null;
    }

    private int indexForKey(String key) {
        if (!this.hasArrays()) {
            return -1;
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get(i).equals(key)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasKey(String key) {
        return this.indexForKey(key) != -1;
    }

    public boolean hasOneOfKeys(String[] keys) {
        for (String key : keys) {
            if (this.indexForKey(key) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean hasKeyValue(String key, String value) {
        int index = this.indexForKey(key);
        if (index == -1) {
            return false;
        }
        return this.values.get(index).equals(value);
    }

    public String get(String key) {
        int index = this.indexForKey(key);
        if (index != -1) {
            return this.values.get(index);
        }
        return null;
    }

    public void set(String key, String value) {
        this.createArrays();
        int index = this.indexForKey(key);
        if (index == -1) {
            this.keys.add(key);
            this.values.add(value);
        } else {
            this.values.set(index, value);
        }
    }

    public int size() {
        if (!this.hasArrays()) {
            return 0;
        }
        return this.keys.size();
    }

    @Override
    public Iterator<String> iterator() {
        if (!this.hasArrays()) {
            return new ArrayList().iterator();
        }
        return this.keys.iterator();
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        String str = "";
        str = str + "[\n";
        for (int i = 0; i < this.size(); ++i) {
            str = str + "\t{ key: \"" + this.keys.get(i) + "\", value: \"" + this.values.get(i) + "\" }\n";
        }
        str = str + "]";
        return str;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.keys);
        out.writeObject(this.values);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.keys = (List)in.readObject();
        this.values = (List)in.readObject();
    }
}

