/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.osm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import net.morbz.osmonaut.geometry.Bounds;
import net.morbz.osmonaut.osm.Entity;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.RelationMember;
import net.morbz.osmonaut.osm.Tags;
import net.morbz.osmonaut.util.StringUtil;

public class Relation
extends Entity {
    private List<RelationMember> members;
    private boolean isIncomplete;

    public boolean isIncomplete() {
        return this.isIncomplete;
    }

    public Relation(long id, Tags tags, List<RelationMember> members, boolean isIncomplete) {
        super(id, tags);
        this.members = members;
        this.isIncomplete = isIncomplete;
    }

    public Relation() {
    }

    public List<RelationMember> getMembers() {
        return this.members;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.RELATION;
    }

    @Override
    public LatLon getCenter() {
        Bounds bounds = new Bounds();
        for (RelationMember member : this.members) {
            LatLon center = member.getEntity().getCenter();
            if (center == null) continue;
            bounds.extend(center);
        }
        return bounds.getCenter();
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        for (RelationMember member : this.members) {
            Bounds memberBounds = member.getEntity().getBounds();
            if (memberBounds == null) continue;
            bounds.extend(memberBounds);
        }
        return bounds;
    }

    public String toString() {
        String str = "";
        str = str + "{\tRELATION\n";
        str = str + "\tid: " + this.id + "\n";
        str = str + "\ttags: " + StringUtil.indent(this.getTags().toString());
        str = str + "\tmembers: [\n";
        for (RelationMember member : this.members) {
            str = str + StringUtil.indent(StringUtil.indent(member.toString()));
        }
        str = str + "\t]\n";
        str = str + "}";
        return str;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.members);
        out.writeBoolean(this.isIncomplete);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.members = (List)in.readObject();
        this.isIncomplete = in.readBoolean();
    }
}

