/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.geometry;

import java.util.ArrayList;
import java.util.List;
import net.morbz.osmonaut.geometry.Bounds;
import net.morbz.osmonaut.geometry.IPolygon;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.Node;
import net.morbz.osmonaut.osm.Way;

public class Polygon
extends IPolygon {
    private List<LatLon> coords = new ArrayList<LatLon>();
    private Bounds bounds = new Bounds();

    public Polygon(List<LatLon> coords) {
        if (coords.size() == 0) {
            return;
        }
        for (LatLon latlon : coords) {
            this.add(latlon);
        }
        if (!coords.get(0).equals(coords.get(coords.size() - 1))) {
            this.add(coords.get(0));
        }
    }

    public Polygon(Way way) {
        if (way.getNodes().size() == 0) {
            return;
        }
        for (Node node : way.getNodes()) {
            this.add(node.getLatlon());
        }
        if (!way.isClosed()) {
            this.add(way.getNodes().get(0).getLatlon());
        }
    }

    private void add(LatLon latlon) {
        this.coords.add(latlon);
        this.bounds.extend(latlon);
    }

    public LatLon getCenter() {
        return this.bounds.getCenter();
    }

    @Override
    public List<LatLon> getCoords() {
        return this.coords;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean contains(LatLon latlon) {
        if (!this.bounds.contains(latlon)) {
            return false;
        }
        boolean isIn = false;
        double lat = latlon.getLat();
        double lon = latlon.getLon();
        int i = 0;
        int j = this.coords.size() - 1;
        while (i < this.coords.size()) {
            double iLon = this.coords.get(i).getLon();
            double iLat = this.coords.get(i).getLat();
            double jLon = this.coords.get(j).getLon();
            double jLat = this.coords.get(j).getLat();
            if (iLon > lon != jLon > lon && lat < (jLat - iLat) * (lon - iLon) / (jLon - iLon) + iLat) {
                isIn = !isIn;
            }
            j = i++;
        }
        return isIn;
    }
}

