/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morbz.osmonaut.geometry.Bounds;
import net.morbz.osmonaut.geometry.IPolygon;
import net.morbz.osmonaut.geometry.MultiPolygonMember;
import net.morbz.osmonaut.geometry.Polygon;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.Node;
import net.morbz.osmonaut.osm.Relation;
import net.morbz.osmonaut.osm.RelationMember;
import net.morbz.osmonaut.osm.Way;

public class MultiPolygon
extends IPolygon {
    private ArrayList<MultiPolygonMember> members = new ArrayList();
    private Bounds bounds = new Bounds();

    public MultiPolygon(Relation relation) {
        ArrayList<List<Node>> innerParts = new ArrayList<List<Node>>();
        ArrayList<List<Node>> outerParts = new ArrayList<List<Node>>();
        block8: for (RelationMember member : relation.getMembers()) {
            MultiPolygonMember.Type type;
            Way way;
            if (member.getEntity().getEntityType() != EntityType.WAY || (way = (Way)member.getEntity()).getNodes().size() <= 1) continue;
            switch (member.getRole()) {
                case "inner": {
                    type = MultiPolygonMember.Type.INNER;
                    break;
                }
                case "outer": {
                    type = MultiPolygonMember.Type.OUTER;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (way.isClosed()) {
                this.add(type, new Polygon(way));
                continue;
            }
            ArrayList<Node> nodes = new ArrayList<Node>(way.getNodes());
            if (type == MultiPolygonMember.Type.INNER) {
                innerParts.add(nodes);
                continue;
            }
            outerParts.add(nodes);
        }
        for (Polygon poly : this.assemblePolygons(innerParts)) {
            this.add(MultiPolygonMember.Type.INNER, poly);
        }
        for (Polygon poly : this.assemblePolygons(outerParts)) {
            this.add(MultiPolygonMember.Type.OUTER, poly);
        }
    }

    private List<Polygon> assemblePolygons(List<List<Node>> parts) {
        ArrayList<List<Node>> polyParts = new ArrayList<List<Node>>();
        for (List<Node> part : parts) {
            long l = part.get(0).getId();
            long lastNode = part.get(part.size() - 1).getId();
            List<Node> newPart = null;
            for (long node : new long[]{l, lastNode}) {
                List<Node> polyPart = this.getConnectingPart(polyParts, node);
                if (polyPart == null) continue;
                polyParts.remove(polyPart);
                newPart = this.joinParts(newPart != null ? newPart : part, polyPart);
            }
            polyParts.add(newPart != null ? newPart : part);
        }
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (List list : polyParts) {
            ArrayList<LatLon> coords = new ArrayList<LatLon>();
            for (Node node : list) {
                coords.add(node.getLatlon());
            }
            polys.add(new Polygon(coords));
        }
        return polys;
    }

    private List<Node> getConnectingPart(List<List<Node>> polyParts, long node) {
        for (List<Node> tmpPolyPart : polyParts) {
            if (tmpPolyPart.get(0).getId() == node) {
                return tmpPolyPart;
            }
            if (tmpPolyPart.get(tmpPolyPart.size() - 1).getId() != node) continue;
            return tmpPolyPart;
        }
        return null;
    }

    private List<Node> joinParts(List<Node> part1, List<Node> part2) {
        long p1First = part1.get(0).getId();
        long p1Last = part1.get(part1.size() - 1).getId();
        long p2First = part2.get(0).getId();
        long p2Last = part2.get(part2.size() - 1).getId();
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (p1Last == p2First) {
            nodes.addAll(part1);
            nodes.remove(nodes.size() - 1);
            nodes.addAll(part2);
        } else if (p2Last == p1First) {
            nodes.addAll(part2);
            nodes.remove(nodes.size() - 1);
            nodes.addAll(part1);
        } else {
            ArrayList<Node> reversed2 = new ArrayList<Node>(part2);
            Collections.reverse(reversed2);
            if (p1First == p2First) {
                nodes.addAll(reversed2);
                nodes.remove(nodes.size() - 1);
                nodes.addAll(part1);
            } else if (p1Last == p2Last) {
                nodes.addAll(part1);
                nodes.remove(nodes.size() - 1);
                nodes.addAll(reversed2);
            }
        }
        return nodes;
    }

    private void add(MultiPolygonMember.Type type, Polygon polygon) {
        this.members.add(new MultiPolygonMember(type, polygon));
        this.bounds.extend(polygon.getBounds());
    }

    public ArrayList<MultiPolygonMember> getMembers() {
        return this.members;
    }

    @Override
    public List<LatLon> getCoords() {
        ArrayList<LatLon> coords = new ArrayList<LatLon>();
        for (MultiPolygonMember member : this.members) {
            coords.addAll(member.getPolygon().getCoords());
        }
        return coords;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean contains(LatLon latlon) {
        if (!this.bounds.contains(latlon)) {
            return false;
        }
        int innerCount = 0;
        int outerCount = 0;
        for (MultiPolygonMember member : this.members) {
            if (!member.getPolygon().contains(latlon)) continue;
            if (member.getType() == MultiPolygonMember.Type.INNER) {
                ++innerCount;
                continue;
            }
            ++outerCount;
        }
        return outerCount > innerCount;
    }
}

