/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.morbz.osmonaut.EntityMap;
import net.morbz.osmonaut.osm.Entity;

public class MemoryEntityMap<T extends Entity>
implements EntityMap<T> {
    private List<List<T>> buckets = new ArrayList<List<T>>();
    private boolean sorted = true;
    private static final int entitiesPerBucket = 1000000;

    @Override
    public void add(T entity) {
        int bucketId = this.getBucketId(((Entity)entity).getId());
        while (!this.arraySpaceAllocated(bucketId)) {
            this.buckets.add(null);
        }
        List<T> bucket = this.buckets.get(bucketId);
        if (bucket == null) {
            bucket = new ArrayList<T>();
            this.buckets.set(bucketId, bucket);
        }
        bucket.add(entity);
        this.sorted = false;
    }

    @Override
    public T get(long id) {
        int bucketId;
        if (!this.sorted) {
            this.sort();
            this.sorted = true;
        }
        if (!this.arraySpaceAllocated(bucketId = this.getBucketId(id))) {
            return null;
        }
        List<T> bucket = this.buckets.get(bucketId);
        if (bucket == null) {
            return null;
        }
        int low = 0;
        int high = bucket.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midId = ((Entity)bucket.get(mid)).getId();
            if (midId < id) {
                low = mid + 1;
                continue;
            }
            if (midId > id) {
                high = mid - 1;
                continue;
            }
            return (T)((Entity)bucket.get(mid));
        }
        return null;
    }

    private void sort() {
        Comparator comp = new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                return Long.compare(((Entity)t1).getId(), ((Entity)t2).getId());
            }
        };
        for (List<T> bucket : this.buckets) {
            if (bucket == null) continue;
            Collections.sort(bucket, comp);
        }
    }

    private int getBucketId(long id) {
        return (int)(id / 1000000L);
    }

    private boolean arraySpaceAllocated(int bucketId) {
        return this.buckets.size() >= bucketId + 1;
    }
}

