/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.binary.pbf;

import net.morbz.osmonaut.binary.pbf.proto.Osmformat;

public class PbfFieldDecoder {
    private static final double COORDINATE_SCALING_FACTOR = 1.0E-9;
    private String[] strings;
    private int coordGranularity;
    private long coordLatitudeOffset;
    private long coordLongitudeOffset;

    public PbfFieldDecoder(Osmformat.PrimitiveBlock primitiveBlock) {
        this.coordGranularity = primitiveBlock.getGranularity();
        this.coordLatitudeOffset = primitiveBlock.getLatOffset();
        this.coordLongitudeOffset = primitiveBlock.getLonOffset();
        Osmformat.PrimitiveBlock.StringTable stringTable = primitiveBlock.getStringtable();
        this.strings = new String[stringTable.getSCount()];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = stringTable.getS(i).toStringUtf8();
        }
    }

    public double decodeLatitude(long rawLatitude) {
        return 1.0E-9 * (double)(this.coordLatitudeOffset + (long)this.coordGranularity * rawLatitude);
    }

    public double decodeLongitude(long rawLongitude) {
        return 1.0E-9 * (double)(this.coordLongitudeOffset + (long)this.coordGranularity * rawLongitude);
    }

    public String decodeString(int rawString) {
        return this.strings[rawString];
    }
}

