/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.binary.pbf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.morbz.osmonaut.EntityFilter;
import net.morbz.osmonaut.binary.OsmonautSink;
import net.morbz.osmonaut.binary.pbf.PbfBlobDecoder;
import net.morbz.osmonaut.binary.pbf.PbfBlobDecoderListener;
import net.morbz.osmonaut.binary.pbf.PbfBlobResult;
import net.morbz.osmonaut.binary.pbf.PbfRawBlob;
import net.morbz.osmonaut.binary.pbf.RawBlobIndexer;
import net.morbz.osmonaut.binary.pbf.RawBlobProvider;
import net.morbz.osmonaut.binary.pbf.RawBlobReader;
import net.morbz.osmonaut.osm.Entity;
import net.morbz.osmonaut.osm.EntityType;

public class PbfDecoder {
    private int maxPendingBlobs;
    private Lock lock;
    private Condition dataWaitCondition;
    private Queue<PbfBlobResult> blobResults;
    private int workers;
    private OsmonautSink sink;
    private RandomAccessFile inputStream;
    private ExecutorService executorService;
    private RawBlobIndexer nodeIndexer;
    private RawBlobIndexer wayIndexer;
    private RawBlobIndexer relationIndexer;
    private boolean firstScan = true;

    public PbfDecoder(File file, int workers) {
        this.workers = workers;
        this.maxPendingBlobs = workers + 1;
        try {
            this.inputStream = new RandomAccessFile(file, "r");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read PBF file " + file + ".", e);
        }
        this.nodeIndexer = new RawBlobIndexer(this.inputStream);
        this.wayIndexer = new RawBlobIndexer(this.inputStream);
        this.relationIndexer = new RawBlobIndexer(this.inputStream);
        this.lock = new ReentrantLock();
        this.dataWaitCondition = this.lock.newCondition();
        this.blobResults = new LinkedList<PbfBlobResult>();
    }

    private void waitForUpdate() {
        try {
            this.dataWaitCondition.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread was interrupted.", e);
        }
    }

    private void signalUpdate() {
        this.dataWaitCondition.signal();
    }

    private void sendResultsToSink(int targetQueueSize) {
        while (this.blobResults.size() > targetQueueSize) {
            PbfBlobResult blobResult = this.blobResults.remove();
            while (!blobResult.isComplete()) {
                this.waitForUpdate();
            }
            if (!blobResult.isSuccess()) {
                throw new RuntimeException("A PBF decoding worker thread failed, aborting.");
            }
            this.lock.unlock();
            for (Entity entity : blobResult.getEntities()) {
                this.sink.foundEntity(entity);
            }
            this.lock.lock();
        }
    }

    private void processBlobs(EntityType type) {
        RawBlobProvider provider = null;
        if (this.firstScan) {
            provider = new RawBlobReader(this.inputStream);
        } else {
            switch (type) {
                case NODE: {
                    provider = this.nodeIndexer;
                    break;
                }
                case WAY: {
                    provider = this.wayIndexer;
                    break;
                }
                case RELATION: {
                    provider = this.relationIndexer;
                }
            }
        }
        while (provider.hasNext()) {
            final PbfRawBlob rawBlob = (PbfRawBlob)provider.next();
            final PbfBlobResult blobResult = new PbfBlobResult();
            this.blobResults.add(blobResult);
            PbfBlobDecoderListener decoderListener = new PbfBlobDecoderListener(){

                @Override
                public void error() {
                    PbfDecoder.this.lock.lock();
                    try {
                        blobResult.storeFailureResult();
                        PbfDecoder.this.signalUpdate();
                    }
                    finally {
                        PbfDecoder.this.lock.unlock();
                    }
                }

                @Override
                public void complete(List<Entity> decodedEntities, EntityFilter containedTypes) {
                    PbfDecoder.this.lock.lock();
                    try {
                        blobResult.storeSuccessResult(decodedEntities);
                        PbfDecoder.this.indexBlob(rawBlob, containedTypes);
                        PbfDecoder.this.signalUpdate();
                    }
                    finally {
                        PbfDecoder.this.lock.unlock();
                    }
                }
            };
            PbfBlobDecoder blobDecoder = new PbfBlobDecoder(rawBlob.getType(), rawBlob.getData(), decoderListener, type);
            this.executorService.execute(blobDecoder);
            this.sendResultsToSink(this.maxPendingBlobs - 1);
        }
        this.sendResultsToSink(0);
        this.firstScan = false;
        provider.resetIterator();
    }

    private void indexBlob(PbfRawBlob rawBlob, EntityFilter containedTypes) {
        if (!this.firstScan) {
            return;
        }
        long fileOffset = rawBlob.getFileOffset();
        int blobSize = rawBlob.getData().length;
        if (containedTypes.getEntityEnabled(EntityType.NODE)) {
            this.nodeIndexer.indexBlob(fileOffset, blobSize);
        }
        if (containedTypes.getEntityEnabled(EntityType.WAY)) {
            this.wayIndexer.indexBlob(fileOffset, blobSize);
        }
        if (containedTypes.getEntityEnabled(EntityType.RELATION)) {
            this.relationIndexer.indexBlob(fileOffset, blobSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(EntityType type, OsmonautSink sink) {
        this.sink = sink;
        this.executorService = Executors.newFixedThreadPool(this.workers);
        try {
            this.lock.lock();
            try {
                this.processBlobs(type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }
        finally {
            this.executorService.shutdownNow();
        }
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

