/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.binary.pbf;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.morbz.osmonaut.EntityFilter;
import net.morbz.osmonaut.binary.pbf.PbfBlobDecoderListener;
import net.morbz.osmonaut.binary.pbf.PbfFieldDecoder;
import net.morbz.osmonaut.binary.pbf.proto.Fileformat;
import net.morbz.osmonaut.binary.pbf.proto.Osmformat;
import net.morbz.osmonaut.osm.Entity;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.Node;
import net.morbz.osmonaut.osm.Relation;
import net.morbz.osmonaut.osm.RelationMember;
import net.morbz.osmonaut.osm.Tags;
import net.morbz.osmonaut.osm.Way;

public class PbfBlobDecoder
implements Runnable {
    private String blobType;
    private byte[] rawBlob;
    private PbfBlobDecoderListener listener;
    private List<Entity> decodedEntities;
    private EntityType entityType;
    private PbfFieldDecoder fieldDecoder;
    private EntityFilter containedTypes = new EntityFilter(false, false, false);

    public PbfBlobDecoder(String blobType, byte[] rawBlob, PbfBlobDecoderListener listener, EntityType type) {
        this.blobType = blobType;
        this.rawBlob = rawBlob;
        this.listener = listener;
        this.entityType = type;
    }

    private byte[] readBlobContent() throws IOException {
        byte[] blobData;
        Fileformat.Blob blob = Fileformat.Blob.parseFrom(this.rawBlob);
        if (blob.hasRaw()) {
            blobData = blob.getRaw().toByteArray();
        } else if (blob.hasZlibData()) {
            Inflater inflater = new Inflater();
            inflater.setInput(blob.getZlibData().toByteArray());
            blobData = new byte[blob.getRawSize()];
            try {
                inflater.inflate(blobData);
            }
            catch (DataFormatException e) {
                throw new RuntimeException("Unable to decompress PBF blob.", e);
            }
            if (!inflater.finished()) {
                throw new RuntimeException("PBF blob contains incomplete compressed data.");
            }
        } else {
            throw new RuntimeException("PBF blob uses unsupported compression, only raw or zlib may be used.");
        }
        return blobData;
    }

    private void processOsmHeader(byte[] data) throws InvalidProtocolBufferException {
        Osmformat.HeaderBlock header = Osmformat.HeaderBlock.parseFrom(data);
        List<String> supportedFeatures = Arrays.asList("OsmSchema-V0.6", "DenseNodes");
        ArrayList<String> activeFeatures = new ArrayList<String>();
        ArrayList<String> unsupportedFeatures = new ArrayList<String>();
        for (String feature : header.getRequiredFeaturesList()) {
            if (supportedFeatures.contains(feature)) {
                activeFeatures.add(feature);
                continue;
            }
            unsupportedFeatures.add(feature);
        }
        if (unsupportedFeatures.size() > 0) {
            throw new RuntimeException("PBF file contains unsupported features " + unsupportedFeatures);
        }
    }

    private Tags buildTags(List<Integer> keys, List<Integer> values) {
        if (keys.size() != values.size()) {
            throw new RuntimeException("Number of tag keys (" + keys.size() + ") and tag values (" + values.size() + ") don't match");
        }
        Tags tags = new Tags();
        Iterator<Integer> keyIterator = keys.iterator();
        Iterator<Integer> valueIterator = values.iterator();
        while (keyIterator.hasNext()) {
            String key = this.fieldDecoder.decodeString(keyIterator.next());
            String value = this.fieldDecoder.decodeString(valueIterator.next());
            tags.set(key, value);
        }
        return tags;
    }

    private void processNodes(List<Osmformat.PrimitiveBlock.PrimitiveGroup.Node> nodes) {
        for (Osmformat.PrimitiveBlock.PrimitiveGroup.Node node : nodes) {
            long id = node.getId();
            Tags tags = this.buildTags(node.getKeysList(), node.getValsList());
            LatLon latlon = new LatLon(node.getLat(), node.getLon());
            Node osmNode = new Node(id, tags, latlon);
            this.decodedEntities.add(osmNode);
        }
    }

    private void processNodes(Osmformat.PrimitiveBlock.PrimitiveGroup.DenseNodes nodes) {
        List<Long> idList = nodes.getIdList();
        List<Long> latList = nodes.getLatList();
        List<Long> lonList = nodes.getLonList();
        if (idList.size() != latList.size() || idList.size() != lonList.size()) {
            throw new RuntimeException("Number of ids (" + idList.size() + "), latitudes (" + latList.size() + "), and longitudes (" + lonList.size() + ") don't match");
        }
        Iterator<Integer> keysValuesIterator = nodes.getKeysValsList().iterator();
        long nodeId = 0L;
        long latitude = 0L;
        long longitude = 0L;
        for (int i = 0; i < idList.size(); ++i) {
            int keyIndex;
            nodeId += idList.get(i).longValue();
            latitude += latList.get(i).longValue();
            longitude += lonList.get(i).longValue();
            Tags tags = new Tags();
            while (keysValuesIterator.hasNext() && (keyIndex = keysValuesIterator.next().intValue()) != 0) {
                if (!keysValuesIterator.hasNext()) {
                    throw new RuntimeException("The PBF DenseInfo keys/values list contains a key with no corresponding value.");
                }
                int valueIndex = keysValuesIterator.next();
                tags.set(this.fieldDecoder.decodeString(keyIndex), this.fieldDecoder.decodeString(valueIndex));
            }
            LatLon latlon = new LatLon(this.fieldDecoder.decodeLatitude(latitude), this.fieldDecoder.decodeLongitude(longitude));
            Node osmNode = new Node(nodeId, tags, latlon);
            this.decodedEntities.add(osmNode);
        }
    }

    private void processWays(List<Osmformat.PrimitiveBlock.PrimitiveGroup.Way> ways) {
        for (Osmformat.PrimitiveBlock.PrimitiveGroup.Way way : ways) {
            long nodeId = 0L;
            ArrayList<Node> wayNodes = new ArrayList<Node>();
            for (long nodeIdOffset : way.getRefsList()) {
                wayNodes.add(new Node(nodeId += nodeIdOffset, null, null));
            }
            long id = way.getId();
            Tags tags = this.buildTags(way.getKeysList(), way.getValsList());
            Way osmWay = new Way(id, tags, wayNodes);
            this.decodedEntities.add(osmWay);
        }
    }

    private void processRelations(List<Osmformat.PrimitiveBlock.PrimitiveGroup.Relation> relations) {
        for (Osmformat.PrimitiveBlock.PrimitiveGroup.Relation relation : relations) {
            List<Long> memberIds = relation.getMemidsList();
            List<Integer> memberRoles = relation.getRolesSidList();
            List<Osmformat.PrimitiveBlock.PrimitiveGroup.Relation.MemberType> memberTypes = relation.getTypesList();
            if (memberIds.size() != memberRoles.size() || memberIds.size() != memberTypes.size()) {
                throw new RuntimeException("Number of member ids (" + memberIds.size() + "), member roles (" + memberRoles.size() + "), and member types (" + memberTypes.size() + ") don't match");
            }
            Iterator<Long> memberIdIterator = memberIds.iterator();
            Iterator<Integer> memberRoleIterator = memberRoles.iterator();
            Iterator<Osmformat.PrimitiveBlock.PrimitiveGroup.Relation.MemberType> memberTypeIterator = memberTypes.iterator();
            long memberId = 0L;
            ArrayList<RelationMember> members = new ArrayList<RelationMember>();
            boolean isIncomplete = false;
            block6: while (memberIdIterator.hasNext()) {
                memberId += memberIdIterator.next().longValue();
                String memberRole = this.fieldDecoder.decodeString(memberRoleIterator.next());
                Entity entity = null;
                Osmformat.PrimitiveBlock.PrimitiveGroup.Relation.MemberType memberType = memberTypeIterator.next();
                switch (memberType) {
                    case NODE: {
                        entity = new Node(memberId, null, null);
                        break;
                    }
                    case WAY: {
                        entity = new Way(memberId, null, null);
                        break;
                    }
                    case RELATION: {
                        isIncomplete = true;
                        continue block6;
                    }
                }
                RelationMember member = new RelationMember(entity, memberRole);
                members.add(member);
            }
            long id = relation.getId();
            Tags tags = this.buildTags(relation.getKeysList(), relation.getValsList());
            Relation osmRelation = new Relation(id, tags, members, isIncomplete);
            this.decodedEntities.add(osmRelation);
        }
    }

    private void processOsmPrimitives(byte[] data) throws InvalidProtocolBufferException {
        Osmformat.PrimitiveBlock block = Osmformat.PrimitiveBlock.parseFrom(data);
        this.fieldDecoder = new PbfFieldDecoder(block);
        for (Osmformat.PrimitiveBlock.PrimitiveGroup group : block.getPrimitivegroupList()) {
            if (group.hasDense() || group.getNodesCount() > 0) {
                this.containedTypes.setEntityEnabled(EntityType.NODE, true);
                if (this.entityType == EntityType.NODE) {
                    this.processNodes(group.getDense());
                    this.processNodes(group.getNodesList());
                }
            }
            if (group.getWaysCount() > 0) {
                this.containedTypes.setEntityEnabled(EntityType.WAY, true);
                if (this.entityType == EntityType.WAY) {
                    this.processWays(group.getWaysList());
                }
            }
            if (group.getRelationsCount() <= 0) continue;
            this.containedTypes.setEntityEnabled(EntityType.RELATION, true);
            if (this.entityType != EntityType.RELATION) continue;
            this.processRelations(group.getRelationsList());
        }
    }

    private void runAndTrapExceptions() {
        try {
            this.decodedEntities = new ArrayList<Entity>();
            if ("OSMHeader".equals(this.blobType)) {
                this.processOsmHeader(this.readBlobContent());
            } else if ("OSMData".equals(this.blobType)) {
                this.processOsmPrimitives(this.readBlobContent());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process PBF blob", e);
        }
    }

    @Override
    public void run() {
        try {
            this.runAndTrapExceptions();
            this.listener.complete(this.decodedEntities, this.containedTypes);
        }
        catch (RuntimeException e) {
            this.listener.error();
        }
    }
}

