/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class IdTracker {
    private List<BitSet> segments = new ArrayList<BitSet>();
    private static final int idsPerSegment = 512;

    public void set(long id) {
        int segmentId = this.getSegmentId(id);
        while (!this.arraySpaceAllocated(segmentId)) {
            this.segments.add(null);
        }
        BitSet segment = this.segments.get(segmentId);
        if (segment == null) {
            segment = new BitSet(512);
            this.segments.set(segmentId, segment);
        }
        int segmentPosition = this.getSegmentPosition(id);
        segment.set(segmentPosition);
    }

    public boolean get(long id) {
        int segmentId = this.getSegmentId(id);
        if (!this.arraySpaceAllocated(segmentId)) {
            return false;
        }
        BitSet segment = this.segments.get(segmentId);
        if (segment == null) {
            return false;
        }
        int segmentPosition = this.getSegmentPosition(id);
        return segment.get(segmentPosition);
    }

    public void unset(long id) {
        int segmentId = this.getSegmentId(id);
        if (!this.arraySpaceAllocated(segmentId)) {
            return;
        }
        BitSet segment = this.segments.get(segmentId);
        if (segment == null) {
            return;
        }
        int segmentPosition = this.getSegmentPosition(id);
        segment.clear(segmentPosition);
        if (segment.isEmpty()) {
            this.segments.set(segmentId, null);
        }
    }

    public boolean isEmpty() {
        for (BitSet segment : this.segments) {
            if (segment == null || segment.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int getSegmentId(long id) {
        return (int)(id / 512L);
    }

    private int getSegmentPosition(long id) {
        return (int)(id % 512L);
    }

    private boolean arraySpaceAllocated(int segmentId) {
        return this.segments.size() >= segmentId + 1;
    }
}

