/*
 * Decompiled with CFR 0.152.
 */
package com.github.joelittlejohn.embedmongo;

import com.github.joelittlejohn.embedmongo.AbstractEmbeddedMongoMojo;
import com.github.joelittlejohn.embedmongo.NetworkUtils;
import com.github.joelittlejohn.embedmongo.log.Loggers;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.mongo.config.ExtractedArtifactStoreBuilder;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongoCmdOptionsBuilder;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.config.store.HttpProxyFactory;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IProxyFactory;
import de.flapdoodle.embed.process.config.store.NoProxyFactory;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.exceptions.DistributionException;
import de.flapdoodle.embed.process.runtime.ICommandLinePostProcessor;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractEmbeddedMongoMojo {
    private static final String PACKAGE_NAME = StartMojo.class.getPackage().getName();
    public static final String MONGOD_CONTEXT_PROPERTY_NAME = PACKAGE_NAME + ".mongod";
    @Parameter(property="embedmongo.databaseDirectory")
    private File databaseDirectory;
    @Parameter(property="embedmongo.bindIp")
    private String bindIp;
    @Parameter(property="embedmongo.logging", defaultValue="console")
    private String logging;
    @Parameter(property="embedmongo.logFile", defaultValue="embedmongo.log")
    private String logFile;
    @Parameter(property="embedmongo.logFileEncoding", defaultValue="utf-8")
    private String logFileEncoding;
    @Parameter(property="embedmongo.downloadPath", defaultValue="http://fastdl.mongodb.org/")
    private String downloadPath;
    @Parameter(property="embedmongo.authEnabled", defaultValue="false")
    private boolean authEnabled;
    @Parameter(property="embedmongo.unixSocketPrefix")
    private String unixSocketPrefix;
    @Parameter(property="embedmongo.journal", defaultValue="false")
    private boolean journal;
    @Parameter(property="embedmongo.storageEngine", defaultValue="mmapv1")
    private String storageEngine;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;

    @Override
    protected void savePortToProjectProperties(int port) {
        super.savePortToProjectProperties(port);
    }

    @Override
    protected void onSkip() {
        this.getLog().debug((CharSequence)"skip=true, not starting embedmongo");
    }

    @Override
    public void executeStart() throws MojoExecutionException, MojoFailureException {
        MongodExecutable executable;
        try {
            final List<String> mongodArgs = this.createMongodArgsList();
            ICommandLinePostProcessor commandLinePostProcessor = new ICommandLinePostProcessor(){

                public List<String> process(Distribution distribution, List<String> args) {
                    args.addAll(mongodArgs);
                    return args;
                }
            };
            IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults(Command.MongoD).processOutput(this.getOutputConfig()).artifactStore(this.getArtifactStore()).commandLinePostProcessor(commandLinePostProcessor).build();
            int port = this.getPort();
            if (this.isRandomPort()) {
                port = NetworkUtils.allocateRandomPort();
            }
            this.savePortToProjectProperties(port);
            IMongodConfig config = new MongodConfigBuilder().version(this.getVersion()).net(new Net(this.bindIp, port, NetworkUtils.localhostIsIPv6())).replication(new Storage(this.getDataDirectory(), null, 0)).cmdOptions(new MongoCmdOptionsBuilder().enableAuth(this.authEnabled).useNoJournal(!this.journal).useStorageEngine(this.storageEngine).build()).build();
            executable = (MongodExecutable)MongodStarter.getInstance((IRuntimeConfig)runtimeConfig).prepare((IExecutableProcessConfig)config);
        }
        catch (DistributionException e) {
            throw new MojoExecutionException("Failed to download MongoDB distribution: " + e.withDistribution(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to Config MongoDB: ", (Exception)e);
        }
        try {
            MongodProcess mongod = (MongodProcess)executable.start();
            if (this.isWait()) {
                try {
                    while (true) {
                        TimeUnit.MINUTES.sleep(5L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.getPluginContext().put(MONGOD_CONTEXT_PROPERTY_NAME, mongod);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to start the mongod", (Exception)e);
        }
    }

    private List<String> createMongodArgsList() {
        ArrayList<String> mongodArgs = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1 && this.unixSocketPrefix != null && !this.unixSocketPrefix.isEmpty()) {
            mongodArgs.add("--unixSocketPrefix=" + this.unixSocketPrefix);
        }
        return mongodArgs;
    }

    private ProcessOutput getOutputConfig() throws MojoFailureException {
        Loggers.LoggingStyle loggingStyle = Loggers.LoggingStyle.valueOf(this.logging.toUpperCase());
        switch (loggingStyle) {
            case CONSOLE: {
                return Loggers.console();
            }
            case FILE: {
                return Loggers.file(this.logFile, this.logFileEncoding);
            }
            case NONE: {
                return Loggers.none();
            }
        }
        throw new MojoFailureException("Unexpected logging style encountered: \"" + this.logging + "\" -> " + (Object)((Object)loggingStyle));
    }

    private IArtifactStore getArtifactStore() {
        IDownloadConfig downloadConfig = new DownloadConfigBuilder().defaultsForCommand(Command.MongoD).proxyFactory(this.getProxyFactory(this.settings)).downloadPath(this.downloadPath).build();
        return new ExtractedArtifactStoreBuilder().defaults(Command.MongoD).download(downloadConfig).build();
    }

    public IProxyFactory getProxyFactory(Settings settings) {
        URI downloadUri = URI.create(this.downloadPath);
        String downloadHost = downloadUri.getHost();
        String downloadProto = downloadUri.getScheme();
        if (settings.getProxies() != null) {
            for (Proxy proxy : settings.getProxies()) {
                if (!proxy.isActive() || !StringUtils.equalsIgnoreCase((CharSequence)proxy.getProtocol(), (CharSequence)downloadProto) || StringUtils.contains((CharSequence)proxy.getNonProxyHosts(), (CharSequence)downloadHost)) continue;
                return new HttpProxyFactory(proxy.getHost(), proxy.getPort());
            }
        }
        return new NoProxyFactory();
    }

    private String getDataDirectory() {
        if (this.databaseDirectory != null) {
            return this.databaseDirectory.getAbsolutePath();
        }
        return null;
    }
}

