/*
 * Decompiled with CFR 0.152.
 */
package com.whiteelephant.monthpicker;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.example.prem.firstpitch.R;
import java.util.HashMap;

class YearPickerView
extends ListView {
    private Context _context;
    final YearAdapter _adapter;
    final int _viewSize;
    final int _childSize;
    OnYearSelectedListener _onYearSelectedListener;
    HashMap<String, Integer> _colors;

    public YearPickerView(Context context) {
        this(context, null);
    }

    public YearPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, R.style.AppTheme);
        super.setSelector(17170445);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this._context = context;
        AbsListView.LayoutParams frame = new AbsListView.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)frame);
        Resources res = context.getResources();
        this._viewSize = res.getDimensionPixelOffset(R.dimen.datepicker_view_animator_height);
        this._childSize = res.getDimensionPixelOffset(R.dimen.datepicker_year_label_height);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int year = YearPickerView.this._adapter.getYearForPosition(position);
                YearPickerView.this._adapter.setSelection(year);
                if (YearPickerView.this._onYearSelectedListener != null) {
                    YearPickerView.this._onYearSelectedListener.onYearChanged(YearPickerView.this, year);
                }
            }
        });
        this._adapter = new YearAdapter(this.getContext());
        this.setAdapter((ListAdapter)this._adapter);
    }

    public void setOnYearSelectedListener(OnYearSelectedListener listener) {
        this._onYearSelectedListener = listener;
    }

    public void setYear(final int year) {
        this._adapter.setSelection(year);
        this.post(new Runnable(){

            @Override
            public void run() {
                int position = YearPickerView.this._adapter.getPositionForYear(year);
                if (position >= 0) {
                    YearPickerView.this.setSelectionCentered(position);
                }
            }
        });
    }

    public void setSelectionCentered(int position) {
        int offset = this._viewSize / 2 - this._childSize / 2;
        this.setSelectionFromTop(position, offset);
    }

    public void setRange(int min, int max) {
        this._adapter.setRange(min, max);
    }

    public void setColors(HashMap<String, Integer> colors) {
        this._colors = colors;
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    protected void setMinYear(int minYear) {
        this._adapter.setMinYear(minYear);
    }

    protected void setMaxYear(int maxYear) {
        this._adapter.setMaxYear(maxYear);
    }

    protected void setActivatedYear(int activatedYear) {
        this._adapter.setActivatedYear(activatedYear);
    }

    public static interface OnYearSelectedListener {
        public void onYearChanged(YearPickerView var1, int var2);
    }

    private class YearAdapter
    extends BaseAdapter {
        private final int ITEM_LAYOUT = R.layout.year_label_text_view;
        private final LayoutInflater __inflater;
        private int __activatedYear;
        private int __minYear;
        private int __maxYear;
        private int __count;

        public YearAdapter(Context context) {
            this.__inflater = LayoutInflater.from((Context)context);
        }

        public void setRange(int min, int max) {
            int count = max - min + 1;
            if (this.__minYear != min || this.__maxYear != max || this.__count != count) {
                this.__minYear = min;
                this.__maxYear = max;
                this.__count = count;
                this.notifyDataSetInvalidated();
            }
        }

        public boolean setSelection(int year) {
            if (this.__activatedYear != year) {
                this.__activatedYear = year;
                this.notifyDataSetChanged();
                return true;
            }
            return false;
        }

        public int getCount() {
            return this.__count;
        }

        public Integer getItem(int position) {
            return this.getYearForPosition(position);
        }

        public long getItemId(int position) {
            return this.getYearForPosition(position);
        }

        public int getPositionForYear(int year) {
            return year - this.__minYear;
        }

        public int getYearForPosition(int position) {
            return this.__minYear + position;
        }

        public boolean hasStableIds() {
            return true;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            boolean activated;
            boolean hasNewView = convertView == null;
            TextView v = hasNewView ? (TextView)this.__inflater.inflate(this.ITEM_LAYOUT, parent, false) : (TextView)convertView;
            int year = this.getYearForPosition(position);
            boolean bl = activated = this.__activatedYear == year;
            if (hasNewView || v.getTag() != null || v.getTag().equals(activated)) {
                if (activated) {
                    if (YearPickerView.this._colors.containsKey("monthBgSelectedColor")) {
                        v.setTextColor(YearPickerView.this._colors.get("monthBgSelectedColor").intValue());
                    }
                    v.setTextSize(25.0f);
                } else {
                    if (YearPickerView.this._colors.containsKey("monthFontColorNormal")) {
                        v.setTextColor(YearPickerView.this._colors.get("monthFontColorNormal").intValue());
                    }
                    v.setTextSize(20.0f);
                }
                v.setTag((Object)activated);
            }
            v.setText((CharSequence)Integer.toString(year));
            return v;
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public boolean isEnabled(int position) {
            return true;
        }

        protected void setMaxYear(int maxYear) {
            this.__maxYear = maxYear;
            this.__count = this.__maxYear - this.__minYear + 1;
            this.notifyDataSetInvalidated();
        }

        protected void setMinYear(int minYear) {
            this.__minYear = minYear;
            this.__count = this.__maxYear - this.__minYear + 1;
            this.notifyDataSetInvalidated();
        }

        protected void setActivatedYear(int activatedYear) {
            if (activatedYear < this.__minYear || activatedYear > this.__maxYear) {
                throw new IllegalArgumentException("activated date is not in range");
            }
            this.__activatedYear = activatedYear;
            YearPickerView.this.setYear(activatedYear);
        }
    }
}

