/*
 * Decompiled with CFR 0.152.
 */
package com.whiteelephant.monthpicker;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import com.example.prem.firstpitch.R;
import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;

class MonthView
extends ListView {
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_NUM_DAYS = 4;
    private static final int DEFAULT_NUM_ROWS = 3;
    private static final int MAX_NUM_ROWS = 3;
    private static final int DAY_SEPARATOR_WIDTH = 1;
    private int _numDays;
    private int _numCells;
    private int _numRows;
    private int _padding;
    private int _width;
    private int _rowHeight;
    private Paint _monthNumberPaint;
    private Paint _monthNumberDisabledPaint;
    private Paint _monthNumberSelectedPaint;
    private String[] _monthNames;
    private int _monthTextSize;
    private int _monthHeaderSize;
    private int _monthSelectedCircleSize;
    private int _monthBgSelectedColor;
    private int _monthFontColorNormal;
    private int _monthFontColorSelected;
    private int _monthFontColorDisabled;
    private int _maxMonth;
    private int _minMonth;
    private int _rowHeightKey;
    private int _selectedMonth;
    private OnMonthClickListener _onMonthClickListener;

    public MonthView(Context context) {
        this(context, null);
    }

    public MonthView(Context context, AttributeSet attrs) {
        this(context, attrs, R.style.MonthPickerDialogStyle);
    }

    public MonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this._numCells = this._numDays = 4;
        this._numRows = 3;
        this._padding = 40;
        this._rowHeight = 100;
        this._selectedMonth = -1;
        this._monthNames = new DateFormatSymbols(Locale.getDefault()).getShortMonths();
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this._monthTextSize = (int)TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)displayMetrics);
        this._monthHeaderSize = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)displayMetrics);
        this._monthSelectedCircleSize = this.getResources().getConfiguration().orientation == 1 ? (int)TypedValue.applyDimension((int)1, (float)43.0f, (DisplayMetrics)displayMetrics) : (int)TypedValue.applyDimension((int)1, (float)43.0f, (DisplayMetrics)displayMetrics);
        this._rowHeightKey = (int)TypedValue.applyDimension((int)1, (float)250.0f, (DisplayMetrics)displayMetrics);
        this._rowHeight = (this._rowHeightKey - this._monthHeaderSize) / 3;
        this._padding = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)displayMetrics);
    }

    private void initView() {
        this._monthNumberSelectedPaint = new Paint();
        this._monthNumberSelectedPaint.setAntiAlias(true);
        if (this._monthBgSelectedColor != 0) {
            this._monthNumberSelectedPaint.setColor(this._monthBgSelectedColor);
        }
        this._monthNumberSelectedPaint.setTextAlign(Paint.Align.CENTER);
        this._monthNumberSelectedPaint.setStyle(Paint.Style.FILL);
        this._monthNumberSelectedPaint.setFakeBoldText(true);
        this._monthNumberPaint = new Paint();
        this._monthNumberPaint.setAntiAlias(true);
        if (this._monthFontColorNormal != 0) {
            this._monthNumberPaint.setColor(this._monthFontColorNormal);
        }
        this._monthNumberPaint.setTextSize((float)this._monthTextSize);
        this._monthNumberPaint.setTextAlign(Paint.Align.CENTER);
        this._monthNumberPaint.setStyle(Paint.Style.FILL);
        this._monthNumberPaint.setFakeBoldText(false);
        this._monthNumberDisabledPaint = new Paint();
        this._monthNumberDisabledPaint.setAntiAlias(true);
        if (this._monthFontColorDisabled != 0) {
            this._monthNumberDisabledPaint.setColor(this._monthFontColorDisabled);
        }
        this._monthNumberDisabledPaint.setTextSize((float)this._monthTextSize);
        this._monthNumberDisabledPaint.setTextAlign(Paint.Align.CENTER);
        this._monthNumberDisabledPaint.setStyle(Paint.Style.FILL);
        this._monthNumberDisabledPaint.setFakeBoldText(false);
    }

    protected void onDraw(Canvas canvas) {
        this.drawDays(canvas);
    }

    private void drawDays(Canvas canvas) {
        int y = (this._rowHeight + this._monthTextSize) / 2 - 1 + this._monthHeaderSize;
        int dayWidthHalf = (this._width - this._padding * 2) / (this._numDays * 2);
        int j = 0;
        for (int month = 0; month < this._monthNames.length; ++month) {
            int x = (2 * j + 1) * dayWidthHalf + this._padding;
            if (this._selectedMonth == month) {
                canvas.drawCircle((float)x, (float)(y - this._monthTextSize / 3), (float)this._monthSelectedCircleSize, this._monthNumberSelectedPaint);
                if (this._monthFontColorSelected != 0) {
                    this._monthNumberPaint.setColor(this._monthFontColorSelected);
                }
            } else if (this._monthFontColorNormal != 0) {
                this._monthNumberPaint.setColor(this._monthFontColorNormal);
            }
            Paint paint = month < this._minMonth || month > this._maxMonth ? this._monthNumberDisabledPaint : this._monthNumberPaint;
            canvas.drawText(this._monthNames[month], (float)x, (float)y, paint);
            if (++j != this._numDays) continue;
            j = 0;
            y += this._rowHeight;
        }
    }

    private int getMonthFromLocation(float x, float y) {
        int dayStart = this._padding;
        if (x < (float)dayStart || x > (float)(this._width - this._padding)) {
            return -1;
        }
        int row = (int)(y - (float)this._monthHeaderSize) / this._rowHeight;
        int column = (int)((x - (float)dayStart) * (float)this._numDays / (float)(this._width - dayStart - this._padding));
        int day = column + 1;
        if ((day += row * this._numDays) < 0 || day > this._numCells) {
            return -1;
        }
        return day - 1;
    }

    private void onDayClick(int day) {
        if (this._onMonthClickListener != null) {
            this._onMonthClickListener.onMonthClick(this, day);
        }
    }

    protected void setColors(HashMap<String, Integer> colors) {
        if (colors.containsKey("monthBgSelectedColor")) {
            this._monthBgSelectedColor = colors.get("monthBgSelectedColor");
        }
        if (colors.containsKey("monthFontColorNormal")) {
            this._monthFontColorNormal = colors.get("monthFontColorNormal");
        }
        if (colors.containsKey("monthFontColorSelected")) {
            this._monthFontColorSelected = colors.get("monthFontColorSelected");
        }
        if (colors.containsKey("monthFontColorDisabled")) {
            this._monthFontColorDisabled = colors.get("monthFontColorDisabled");
        }
        this.initView();
    }

    public void setOnMonthClickListener(OnMonthClickListener listener) {
        this._onMonthClickListener = listener;
    }

    void setMonthParams(int selectedMonth, int minMonth, int maxMonth) {
        this._selectedMonth = selectedMonth;
        this._minMonth = minMonth;
        this._maxMonth = maxMonth;
        this._numCells = 12;
    }

    public void reuse() {
        this._numRows = 3;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this._rowHeight * this._numRows + this._monthHeaderSize * 2);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this._width = w;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int day = this.getMonthFromLocation(event.getX(), event.getY());
                if (day < 0) break;
                this.onDayClick(day);
            }
        }
        return true;
    }

    public static interface OnMonthClickListener {
        public void onMonthClick(MonthView var1, int var2);
    }
}

