/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public abstract class ContainerSerializer<T>
extends StdSerializer<T> {
    protected ContainerSerializer(Class<T> t) {
        super(t);
    }

    protected ContainerSerializer(JavaType fullType) {
        super(fullType);
    }

    protected ContainerSerializer(Class<?> t, boolean dummy) {
        super(t, dummy);
    }

    protected ContainerSerializer(ContainerSerializer<?> src) {
        super(src._handledType, false);
    }

    public ContainerSerializer<?> withValueTypeSerializer(TypeSerializer vts) {
        if (vts == null) {
            return this;
        }
        return this._withValueTypeSerializer(vts);
    }

    public abstract JavaType getContentType();

    public abstract JsonSerializer<?> getContentSerializer();

    public abstract boolean hasSingleElement(T var1);

    protected abstract ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer var1);

    @Deprecated
    protected boolean hasContentTypeAnnotation(SerializerProvider provider, BeanProperty property) {
        return false;
    }

    protected void serializeElement(JsonSerializer<Object> serializer, Object elem, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer, boolean handleCircularReferencesIndividually) throws IOException {
        if (serializer instanceof AsArraySerializerBase) {
            this.serializeArrayElement((AsArraySerializerBase)serializer, elem, g, provider, typeSer, handleCircularReferencesIndividually);
        } else {
            this.serializeElement(serializer, elem, g, provider, typeSer);
        }
    }

    private void serializeElement(JsonSerializer<Object> serializer, Object elem, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (typeSer == null) {
            serializer.serialize(elem, g, provider);
        } else {
            serializer.serializeWithType(elem, g, provider, typeSer);
        }
    }

    private void serializeArrayElement(AsArraySerializerBase serializer, Object elem, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer, boolean handleCircularReferencesIndividually) throws IOException {
        if (typeSer == null) {
            serializer.serialize(elem, g, provider, handleCircularReferencesIndividually);
        } else {
            serializer.serializeWithType(elem, g, provider, typeSer, handleCircularReferencesIndividually);
        }
    }
}

