/*
 * Decompiled with CFR 0.152.
 */
package com.joaquimley.faboptions;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.MenuRes;
import android.support.annotation.RequiresApi;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.widget.AppCompatImageView;
import android.transition.ChangeBounds;
import android.transition.ChangeTransform;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.joaquimley.faboptions.FabOptionsBehavior;
import com.joaquimley.faboptions.FabOptionsButtonContainer;
import com.joaquimley.faboptions.R;

@CoordinatorLayout.DefaultBehavior(value=FabOptionsBehavior.class)
public class FabOptions
extends FrameLayout
implements View.OnClickListener {
    private static final String TAG = "FabOptions";
    private static final int NO_DIMENSION = 0;
    private static final long CLOSE_MORPH_TRANSFORM_DURATION = 70L;
    private boolean mIsOpen = false;
    private View.OnClickListener mListener;
    private Menu mMenu;
    private FloatingActionButton mFab;
    private View mBackground;
    private View mSeparator;
    private FabOptionsButtonContainer mButtonContainer;

    public FabOptions(Context context) {
        this(context, null, 0);
    }

    public FabOptions(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FabOptions(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews(context);
        this.setInitialFabIcon();
        TypedArray fabOptionsAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FabOptions, 0, 0);
        this.styleComponent(context, fabOptionsAttributes);
        this.inflateButtonsFromAttrs(context, fabOptionsAttributes);
    }

    private void initViews(Context context) {
        FabOptions.inflate((Context)context, (int)R.layout.faboptions_layout, (ViewGroup)this);
        this.mBackground = this.findViewById(R.id.background);
        this.mButtonContainer = (FabOptionsButtonContainer)this.findViewById(R.id.button_container);
        this.mFab = (FloatingActionButton)this.findViewById(R.id.faboptions_fab);
        this.mFab.setOnClickListener((View.OnClickListener)this);
    }

    private void setInitialFabIcon() {
        if (Build.VERSION.SDK_INT >= 21) {
            VectorDrawable drawable2 = (VectorDrawable)this.getResources().getDrawable(R.drawable.faboptions_ic_overflow, null);
            this.mFab.setImageDrawable((Drawable)drawable2);
        } else {
            this.mFab.setImageResource(R.drawable.faboptions_ic_overflow);
        }
    }

    private void styleComponent(Context context, TypedArray attributes) {
        int fabColor = attributes.getColor(R.styleable.FabOptions_fab_color, this.getThemeAccentColor(context));
        int backgroundColor = attributes.getColor(R.styleable.FabOptions_background_color, fabColor);
        this.setBackgroundColor(context, backgroundColor);
        this.mFab.setBackgroundTintList(ColorStateList.valueOf((int)fabColor));
    }

    public void setFabColor(@ColorRes int fabColor) {
        Context context = this.getContext();
        if (context != null) {
            int colorId = ContextCompat.getColor((Context)context, (int)fabColor);
            this.mFab.setBackgroundTintList(ColorStateList.valueOf((int)colorId));
        }
    }

    public void setBackgroundColor(@ColorRes int backgroundColor) {
        Context context = this.getContext();
        if (context != null) {
            int color = ContextCompat.getColor((Context)context, (int)backgroundColor);
            this.setBackgroundColor(context, color);
        } else {
            Log.w((String)TAG, (String)"Couldn't set background color, context is null");
        }
    }

    private void setBackgroundColor(Context context, @ColorInt int backgroundColor) {
        Drawable backgroundShape = ContextCompat.getDrawable((Context)context, (int)R.drawable.faboptions_background);
        backgroundShape.setColorFilter(backgroundColor, PorterDuff.Mode.ADD);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mBackground.setBackground(backgroundShape);
        } else {
            this.mBackground.setBackgroundDrawable(backgroundShape);
        }
    }

    @ColorInt
    private int getThemeAccentColor(Context context) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
        return value.data;
    }

    private void inflateButtonsFromAttrs(Context context, TypedArray attributes) {
        if (attributes.hasValue(R.styleable.FabOptions_button_menu)) {
            this.setButtonsMenu(context, attributes.getResourceId(R.styleable.FabOptions_button_menu, 0));
        }
    }

    public boolean setButtonColor(int buttonId, @ColorRes int color) {
        for (int i = 0; i < this.mButtonContainer.getChildCount(); ++i) {
            if (this.mMenu.getItem(i).getItemId() != buttonId) continue;
            return this.styleButton(i, color);
        }
        Log.d((String)TAG, (String)("setButtonColor(): Couldn't find button with id " + buttonId));
        return false;
    }

    public void setButtonsMenu(@MenuRes int menuId) {
        Context context = this.getContext();
        if (context != null) {
            this.setButtonsMenu(context, menuId);
        } else {
            Log.w((String)TAG, (String)"Couldn't set buttons, context is null");
        }
    }

    @Deprecated
    public void setButtonsMenu(Context context, @MenuRes int menuId) {
        this.mMenu = new MenuBuilder(context);
        SupportMenuInflater menuInf = new SupportMenuInflater(context);
        menuInf.inflate(menuId, this.mMenu);
        this.addButtonsFromMenu(context, this.mMenu);
        this.mSeparator = this.mButtonContainer.addSeparator(context);
        this.animateButtons(false);
    }

    private void addButtonsFromMenu(Context context, Menu menu) {
        for (int i = 0; i < menu.size(); ++i) {
            this.addButton(context, menu.getItem(i));
        }
    }

    private void addButton(Context context, MenuItem menuItem) {
        AppCompatImageView button = this.mButtonContainer.addButton(context, menuItem.getItemId(), menuItem.getTitle(), menuItem.getIcon());
        button.setOnClickListener((View.OnClickListener)this);
    }

    private boolean styleButton(int buttonIndex, @ColorRes int color) {
        if (buttonIndex >= this.mButtonContainer.getChildCount() / 2) {
            ++buttonIndex;
        }
        if (buttonIndex >= this.mButtonContainer.getChildCount()) {
            Log.e((String)TAG, (String)("Button at " + buttonIndex + " is null (index out of bounds)"));
            return false;
        }
        AppCompatImageView imageView = (AppCompatImageView)this.mButtonContainer.getChildAt(buttonIndex);
        imageView.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)color));
        return true;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.faboptions_fab) {
            if (this.mIsOpen) {
                this.close();
            } else {
                this.open();
            }
        } else if (this.mListener != null) {
            this.mListener.onClick(v);
            this.close();
        }
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mListener = listener;
    }

    private void open() {
        if (Build.VERSION.SDK_INT >= 21) {
            AnimatedVectorDrawable drawable2 = (AnimatedVectorDrawable)this.getResources().getDrawable(R.drawable.faboptions_ic_menu_animatable, null);
            this.mFab.setImageDrawable((Drawable)drawable2);
            drawable2.start();
        } else {
            this.mFab.setImageResource(R.drawable.faboptions_ic_close);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)new OpenMorphTransition((ViewGroup)this.mButtonContainer));
        }
        this.animateBackground(true);
        this.animateButtons(true);
        this.mIsOpen = true;
    }

    private void close() {
        if (Build.VERSION.SDK_INT >= 21) {
            AnimatedVectorDrawable drawable2 = (AnimatedVectorDrawable)this.getResources().getDrawable(R.drawable.faboptions_ic_close_animatable, null);
            this.mFab.setImageDrawable((Drawable)drawable2);
            drawable2.start();
        } else {
            this.mFab.setImageResource(R.drawable.faboptions_ic_overflow);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)new CloseMorphTransition((ViewGroup)this.mButtonContainer));
        }
        this.animateButtons(false);
        this.animateBackground(false);
        this.mIsOpen = false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mSeparator != null) {
            ViewGroup.LayoutParams separatorLayoutParams = this.mSeparator.getLayoutParams();
            separatorLayoutParams.width = this.mFab.getMeasuredWidth();
            separatorLayoutParams.height = this.mFab.getMeasuredHeight();
            this.mSeparator.setLayoutParams(separatorLayoutParams);
        }
    }

    private void animateBackground(boolean isOpen) {
        ViewGroup.LayoutParams backgroundLayoutParams = this.mBackground.getLayoutParams();
        backgroundLayoutParams.width = isOpen ? this.mButtonContainer.getMeasuredWidth() : 0;
        this.mBackground.setLayoutParams(backgroundLayoutParams);
    }

    private void openCompatAnimation() {
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)this.mBackground, (String)"scaleX", (float[])new float[]{1.0f});
        anim.setDuration(30000L);
        anim.start();
    }

    private void closeCompatAnimation() {
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)this.mBackground, (String)"scaleX", (float[])new float[]{0.0f});
        anim.setDuration(3000L);
        anim.start();
        this.animateButtons(false);
    }

    private void animateButtons(boolean isOpen) {
        for (int i = 0; i < this.mButtonContainer.getChildCount(); ++i) {
            this.mButtonContainer.getChildAt(i).setScaleX(isOpen ? 1.0f : 0.0f);
            this.mButtonContainer.getChildAt(i).setScaleY(isOpen ? 1.0f : 0.0f);
        }
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    @RequiresApi(api=19)
    private class CloseMorphTransition
    extends TransitionSet {
        CloseMorphTransition(ViewGroup viewGroup) {
            ChangeBounds changeBound = new ChangeBounds();
            changeBound.excludeChildren(R.id.button_container, true);
            if (Build.VERSION.SDK_INT >= 21) {
                ChangeTransform changeTransform = new ChangeTransform();
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    changeTransform.addTarget(viewGroup.getChildAt(i));
                }
                changeTransform.setDuration(70L);
                this.addTransition((Transition)changeTransform);
            }
            this.addTransition((Transition)changeBound);
            this.setOrdering(0);
        }
    }

    @RequiresApi(api=19)
    private class OpenMorphTransition
    extends TransitionSet {
        OpenMorphTransition(ViewGroup viewGroup) {
            ChangeBounds changeBound = new ChangeBounds();
            changeBound.excludeChildren(R.id.button_container, true);
            this.addTransition((Transition)changeBound);
            if (Build.VERSION.SDK_INT >= 21) {
                ChangeTransform changeTransform = new ChangeTransform();
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    changeTransform.addTarget(viewGroup.getChildAt(i));
                }
                this.addTransition((Transition)changeTransform);
            }
            this.setOrdering(1);
        }
    }
}

