/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jnr.constants.platform.Errno;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Credentials;
import jnr.unixsocket.Native;
import jnr.unixsocket.SockAddrUnix;
import jnr.unixsocket.UnixSocketAddress;

public class UnixSocketChannel
extends NativeSocketChannel {
    private State state;
    private UnixSocketAddress remoteAddress = null;
    private UnixSocketAddress localAddress = null;
    private final ReadWriteLock stateLock = new ReentrantReadWriteLock();

    public static final UnixSocketChannel open() throws IOException {
        return new UnixSocketChannel();
    }

    public static final UnixSocketChannel open(UnixSocketAddress remote) throws IOException {
        UnixSocketChannel channel = new UnixSocketChannel();
        try {
            channel.connect(remote);
        }
        catch (IOException e) {
            channel.close();
            throw e;
        }
        return channel;
    }

    public static final UnixSocketChannel[] pair() throws IOException {
        int[] sockets = new int[]{-1, -1};
        Native.socketpair(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0, sockets);
        return new UnixSocketChannel[]{new UnixSocketChannel(sockets[0], 5), new UnixSocketChannel(sockets[1], 5)};
    }

    public static final UnixSocketChannel fromFD(int fd) {
        return UnixSocketChannel.fromFD(fd, 5);
    }

    public static final UnixSocketChannel fromFD(int fd, int ops) {
        return new UnixSocketChannel(fd, ops);
    }

    private UnixSocketChannel() throws IOException {
        super(Native.socket(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0), 13);
        this.stateLock.writeLock().lock();
        this.state = State.IDLE;
        this.stateLock.writeLock().unlock();
    }

    UnixSocketChannel(int fd, int ops) {
        super(fd, ops);
        this.stateLock.writeLock().lock();
        this.state = State.CONNECTED;
        this.stateLock.writeLock().unlock();
    }

    UnixSocketChannel(int fd, UnixSocketAddress remote) {
        super(fd, 5);
        this.stateLock.writeLock().lock();
        this.state = State.CONNECTED;
        this.stateLock.writeLock().unlock();
        this.remoteAddress = remote;
    }

    private final boolean doConnect(SockAddrUnix remote) throws IOException {
        if (Native.connect(this.getFD(), remote, remote.length()) != 0) {
            Errno error = Errno.valueOf((long)LastError.getLastError((Runtime)Runtime.getSystemRuntime()));
            switch (error) {
                case EAGAIN: 
                case EWOULDBLOCK: {
                    return false;
                }
            }
            throw new IOException(error.toString());
        }
        return true;
    }

    public boolean connect(UnixSocketAddress remote) throws IOException {
        this.remoteAddress = remote;
        if (!this.doConnect(this.remoteAddress.getStruct())) {
            this.stateLock.writeLock().lock();
            this.state = State.CONNECTING;
            this.stateLock.writeLock().unlock();
            return false;
        }
        this.stateLock.writeLock().lock();
        this.state = State.CONNECTED;
        this.stateLock.writeLock().unlock();
        return true;
    }

    public boolean isConnected() {
        this.stateLock.readLock().lock();
        boolean isConnected = this.state == State.CONNECTED;
        this.stateLock.readLock().lock();
        return isConnected;
    }

    public boolean isConnectionPending() {
        this.stateLock.readLock().lock();
        boolean isConnectionPending = this.state == State.CONNECTING;
        this.stateLock.readLock().lock();
        return isConnectionPending;
    }

    public boolean finishConnect() throws IOException {
        this.stateLock.writeLock().lock();
        try {
            switch (this.state) {
                case CONNECTED: {
                    boolean bl = true;
                    return bl;
                }
                case CONNECTING: {
                    if (!this.doConnect(this.remoteAddress.getStruct())) {
                        boolean bl = false;
                        return bl;
                    }
                    this.state = State.CONNECTED;
                    boolean bl = true;
                    return bl;
                }
            }
            throw new IllegalStateException("socket is not waiting for connect to complete");
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public final UnixSocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.remoteAddress != null ? this.remoteAddress : (this.remoteAddress = UnixSocketChannel.getpeername(this.getFD()));
    }

    public final UnixSocketAddress getLocalSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.localAddress != null ? this.localAddress : (this.localAddress = UnixSocketChannel.getsockname(this.getFD()));
    }

    public final Credentials getCredentials() {
        if (!this.isConnected()) {
            return null;
        }
        return Credentials.getCredentials(this.getFD());
    }

    static UnixSocketAddress getpeername(int sockfd) {
        UnixSocketAddress remote = new UnixSocketAddress();
        SockAddrUnix addr = remote.getStruct();
        IntByReference len = new IntByReference(addr.getMaximumLength());
        if (Native.libc().getpeername(sockfd, addr, len) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        if (((Integer)len.getValue()).intValue() == addr.getHeaderLength()) {
            addr.setPath("");
        }
        return remote;
    }

    static UnixSocketAddress getsockname(int sockfd) {
        UnixSocketAddress remote = new UnixSocketAddress();
        SockAddrUnix addr = remote.getStruct();
        int maxLength = addr.getMaximumLength();
        IntByReference len = new IntByReference(addr.getMaximumLength());
        if (Native.libc().getsockname(sockfd, addr, len) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        int headerLength = addr.getHeaderLength();
        if ((Integer)len.getValue() == headerLength) {
            addr.setPath("");
        } else if ((Integer)len.getValue() < maxLength) {
            String path = addr.getPath();
            int newLength = (Integer)len.getValue() - headerLength;
            if (newLength < path.length()) {
                addr.setPath(path.substring(0, (Integer)len.getValue() - headerLength));
            }
        }
        return remote;
    }

    public boolean getKeepAlive() {
        int ret = Native.getsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_KEEPALIVE.intValue());
        return ret == 1;
    }

    public void setKeepAlive(boolean on) {
        Native.setsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_KEEPALIVE, on);
    }

    public int getSoTimeout() {
        return Native.getsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_RCVTIMEO.intValue());
    }

    public void setSoTimeout(int timeout) {
        Native.setsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_RCVTIMEO, timeout);
    }

    static enum State {
        UNINITIALIZED,
        CONNECTED,
        IDLE,
        CONNECTING;

    }
}

