/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.gradle;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit/semver/plugin/gradle/PrintTask;", "Lorg/gradle/api/DefaultTask;", "printout", "Lkotlin/Function0;", "", "desc", "", "(Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "file", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "print", "", "setFile", "writeFile", "fileName", "git-semver-plugin"})
public class PrintTask
extends DefaultTask {
    @NotNull
    private final Function0<Object> printout;
    @Nullable
    private String file;
    private final Logger logger;

    @Inject
    public PrintTask(@NotNull Function0<? extends Object> printout, @NotNull String desc) {
        Intrinsics.checkNotNullParameter(printout, (String)"printout");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        this.printout = printout;
        this.logger = LoggerFactory.getLogger(PrintTask.class);
        this.setGroup("Versioning");
        this.setDescription(desc);
    }

    @Option(option="file", description="Print to a file ")
    public final void setFile(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @TaskAction
    public final void print() {
        String fileName = this.file;
        if (fileName != null) {
            this.writeFile(fileName);
        } else {
            System.out.println(this.printout.invoke());
        }
    }

    private final void writeFile(String fileName) {
        Path path = Paths.get(fileName, new String[0]).toAbsolutePath();
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Path path3 = path2;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        this.logger.info("Writing to " + path);
        Intrinsics.checkNotNull((Object)path);
        CharSequence charSequence = this.printout.invoke().toString();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        PathsKt.writeText((Path)path, (CharSequence)charSequence, (Charset)charset, (OpenOption[])new OpenOption[0]);
    }
}

