/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.scm;

import git.semver.plugin.scm.Commit;
import git.semver.plugin.scm.Tag;
import git.semver.plugin.semver.SemInfoVersion;
import git.semver.plugin.semver.SemverSettings;
import git.semver.plugin.semver.VersionFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 32\u00020\u0001:\u000234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\n '*\u0004\u0018\u00010\u001f0\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0015\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b*J\"\u0010+\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00060,2\u0006\u0010#\u001a\u00020\u001fH\u0002J\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020)2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b2R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lgit/semver/plugin/scm/GitProvider;", "", "settings", "Lgit/semver/plugin/semver/SemverSettings;", "(Lgit/semver/plugin/semver/SemverSettings;)V", "changeLog", "", "Lgit/semver/plugin/scm/Commit;", "it", "Lorg/eclipse/jgit/api/Git;", "changeLog$git_semver_plugin", "checkDirty", "", "noDirtyCheck", "", "isClean", "checkDirty$git_semver_plugin", "createRelease", "startingPath", "Ljava/io/File;", "params", "Lgit/semver/plugin/scm/GitProvider$ReleaseParams;", "createRelease$git_semver_plugin", "getChangeLog", "getChangeLog$git_semver_plugin", "getCommit", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "revWalk", "Lorg/eclipse/jgit/revwalk/RevWalk;", "getHeadCommit", "Lorg/eclipse/jgit/lib/Repository;", "getHeadCommit$git_semver_plugin", "getObjectIdFromRef", "Lorg/eclipse/jgit/lib/ObjectId;", "repository", "ref", "Lorg/eclipse/jgit/lib/Ref;", "getRepository", "kotlin.jvm.PlatformType", "getSemVersion", "Lgit/semver/plugin/semver/SemInfoVersion;", "getSemVersion$git_semver_plugin", "getTags", "", "", "Lgit/semver/plugin/scm/Tag;", "git", "isClean$git_semver_plugin", "semVersion", "semVersion$git_semver_plugin", "Companion", "ReleaseParams", "git-semver-plugin"})
@SourceDebugExtension(value={"SMAP\nGitProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitProvider.kt\ngit/semver/plugin/scm/GitProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n535#2:163\n520#2,6:164\n381#2,7:178\n1557#3:170\n1628#3,3:171\n1485#3:174\n1510#3,3:175\n1513#3,3:185\n1#4:188\n*S KotlinDebug\n*F\n+ 1 GitProvider.kt\ngit/semver/plugin/scm/GitProvider\n*L\n115#1:163\n115#1:164,6\n129#1:178,7\n127#1:170\n127#1:171,3\n129#1:174\n129#1:175,3\n129#1:185,3\n*E\n"})
public final class GitProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SemverSettings settings;
    @NotNull
    private static final String REF_PREFIX = "refs/tags/";
    private static final Logger logger = LoggerFactory.getLogger(GitProvider.class);

    public GitProvider(@NotNull SemverSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SemInfoVersion getSemVersion$git_semver_plugin(@NotNull File startingPath) {
        Intrinsics.checkNotNullParameter((Object)startingPath, (String)"startingPath");
        AutoCloseable autoCloseable = (AutoCloseable)this.getRepository(startingPath);
        Throwable throwable = null;
        try {
            Repository it = (Repository)autoCloseable;
            boolean bl = false;
            SemInfoVersion semInfoVersion = this.semVersion$git_semver_plugin(new Git(it));
            return semInfoVersion;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final SemInfoVersion semVersion$git_semver_plugin(@NotNull Git it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Repository repository = it.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"getRepository(...)");
        VersionFinder versionFinder = new VersionFinder(this.settings, this.getTags(repository));
        Repository repository2 = it.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"getRepository(...)");
        return versionFinder.getVersion(this.getHeadCommit$git_semver_plugin(repository2), this.isClean$git_semver_plugin(it), this.settings.getDefaultPreRelease());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Commit> getChangeLog$git_semver_plugin(@NotNull File startingPath) {
        Intrinsics.checkNotNullParameter((Object)startingPath, (String)"startingPath");
        AutoCloseable autoCloseable = (AutoCloseable)this.getRepository(startingPath);
        Throwable throwable = null;
        try {
            Repository it = (Repository)autoCloseable;
            boolean bl = false;
            List<Commit> list = this.changeLog$git_semver_plugin(new Git(it));
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final List<Commit> changeLog$git_semver_plugin(@NotNull Git it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Repository repository = it.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"getRepository(...)");
        VersionFinder versionFinder = new VersionFinder(this.settings, this.getTags(repository));
        Repository repository2 = it.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"getRepository(...)");
        return versionFinder.getChangeLog(this.getHeadCommit$git_semver_plugin(repository2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createRelease$git_semver_plugin(@NotNull File startingPath, @NotNull ReleaseParams params) {
        Intrinsics.checkNotNullParameter((Object)startingPath, (String)"startingPath");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        AutoCloseable autoCloseable = (AutoCloseable)this.getRepository(startingPath);
        Throwable throwable = null;
        try {
            Repository it = (Repository)autoCloseable;
            boolean bl = false;
            this.createRelease$git_semver_plugin(new Git(it), params);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void createRelease$git_semver_plugin(@NotNull Git it, @NotNull ReleaseParams params) {
        boolean isTag;
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.checkDirty$git_semver_plugin(params.getNoDirtyCheck(), this.isClean$git_semver_plugin(it));
        Repository repository = it.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"getRepository(...)");
        VersionFinder versionFinder = new VersionFinder(this.settings, this.getTags(repository));
        Repository repository2 = it.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"getRepository(...)");
        Commit commit = this.getHeadCommit$git_semver_plugin(repository2);
        String string2 = params.getPreRelease();
        if (string2 != null) {
            char[] cArray = new char[]{'-'};
            string = StringsKt.trimStart((String)string2, (char[])cArray);
        } else {
            string = null;
        }
        SemInfoVersion version2 = versionFinder.getReleaseVersion(commit, string);
        String versionString = SemInfoVersion.toInfoVersionString$default(version2, null, 0, false, false, 15, null);
        logger.info("Saving new version: {}", (Object)versionString);
        boolean isCommit = Companion.isFormatEnabled$git_semver_plugin(params.getCommit(), this.settings.getReleaseCommitTextFormat());
        if (isCommit) {
            String string3 = this.settings.getReleaseCommitTextFormat();
            object = new Object[2];
            object[0] = versionString;
            String string4 = params.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            object[1] = string4;
            String string5 = String.format(string3, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            String commitMessage = string5;
            it.commit().setMessage(((Object)StringsKt.trim((CharSequence)commitMessage)).toString()).call();
        }
        if (isTag = Companion.isFormatEnabled$git_semver_plugin(params.getTag(), this.settings.getReleaseTagNameFormat())) {
            object = this.settings.getReleaseTagNameFormat();
            Object[] objectArray = new Object[]{versionString};
            String string6 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            String name = string6;
            it.tag().setName(name).setMessage(params.getMessage()).call();
            System.out.println((Object)("Created new local Git tag: " + name));
        }
        if (!isCommit && !isTag) {
            System.out.println((Object)("Dry run - calculated version: " + versionString));
        }
    }

    private final Repository getRepository(File startingPath) {
        return ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(FS.DETECTED)).findGitDir(startingPath)).setMustExist(true)).build();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isClean$git_semver_plugin(@NotNull Git git) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Status status = git.status().call();
        if (status.isClean()) {
            return true;
        }
        logger.info("The Git repository is dirty. (Check: {})", (Object)this.settings.getNoDirtyCheck());
        Object object = new Pair[]{TuplesKt.to((Object)"added", (Object)status.getAdded().size()), TuplesKt.to((Object)"changed", (Object)status.getChanged().size()), TuplesKt.to((Object)"removed", (Object)status.getRemoved().size()), TuplesKt.to((Object)"missing", (Object)status.getMissing().size()), TuplesKt.to((Object)"modified", (Object)status.getModified().size()), TuplesKt.to((Object)"conflicting", (Object)status.getConflicting().size()), TuplesKt.to((Object)"untracked", (Object)status.getUntracked().size())};
        Map changes = MapsKt.mapOf((Pair[])object);
        object = changes;
        String string = "Changes: {}";
        Logger logger = GitProvider.logger;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map = destination$iv$iv;
        logger.info(string, (Object)CollectionsKt.joinToString$default((Iterable)map.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        GitProvider.logger.debug("added: {}", (Object)status.getAdded());
        GitProvider.logger.debug("changed: {}", (Object)status.getChanged());
        GitProvider.logger.debug("removed: {}", (Object)status.getRemoved());
        GitProvider.logger.debug("conflicting: {}", (Object)status.getConflicting());
        GitProvider.logger.debug("missing: {}", (Object)status.getMissing());
        GitProvider.logger.debug("modified: {}", (Object)status.getModified());
        GitProvider.logger.debug("untracked: {}", (Object)status.getUntracked());
        return this.settings.getNoDirtyCheck();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<Tag>> getTags(Repository repository) {
        void $this$groupByTo$iv$iv;
        Tag it;
        Iterable $this$mapTo$iv$iv;
        List list = repository.getRefDatabase().getRefsByPrefix(REF_PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRefsByPrefix(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Ref ref = (Ref)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = StringsKt.removePrefix((String)string, (CharSequence)REF_PREFIX);
            Intrinsics.checkNotNull((Object)it);
            String string3 = this.getObjectIdFromRef(repository, (Ref)it).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            collection.add(new Tag(string2, string3));
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Tag)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getSha();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Commit getHeadCommit$git_semver_plugin(@NotNull Repository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RevWalk revWalk = new RevWalk(it);
        ObjectId objectId = it.resolve("HEAD");
        if (objectId == null) {
            return new Commit("", "", 0, SequencesKt.emptySequence(), null, null, null, 112, null);
        }
        ObjectId head = objectId;
        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)head);
        revWalk.markStart(revCommit);
        Intrinsics.checkNotNull((Object)revCommit);
        return this.getCommit(revCommit, revWalk);
    }

    private final Commit getCommit(RevCommit commit, RevWalk revWalk) {
        String string = commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String string2 = commit.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        int n = commit.getCommitTime();
        Sequence sequence = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Commit>, Continuation<? super Unit>, Object>(commit, revWalk, this, null){
            Object L$1;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RevCommit $commit;
            final /* synthetic */ RevWalk $revWalk;
            final /* synthetic */ GitProvider this$0;
            {
                this.$commit = $commit;
                this.$revWalk = $revWalk;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        v0 = this.$commit.getParents();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getParents(...)");
                        var3_4 = v0;
                        var4_5 = 0;
                        var5_6 = var3_4.length;
lbl11:
                        // 2 sources

                        while (var4_5 < var5_6) {
                            parent = var3_4[var4_5];
                            this.$revWalk.parseHeaders((RevObject)parent);
                            Intrinsics.checkNotNull((Object)parent);
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.I$0 = var4_5;
                            this.I$1 = var5_6;
                            this.label = 1;
                            v1 = $this$sequence.yield((Object)GitProvider.access$getCommit(this.this$0, parent, this.$revWalk), (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl32
                        }
                        break;
                    }
                    case 1: {
                        var5_6 = this.I$1;
                        var4_5 = this.I$0;
                        var3_4 = (RevCommit[])this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        ++var4_5;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Commit> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        String string3 = commit.getAuthorIdent().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string4 = commit.getAuthorIdent().getEmailAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEmailAddress(...)");
        Date date = Date.from(commit.getAuthorIdent().getWhenAsInstant());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(...)");
        return new Commit(string, string2, n, (Sequence<Commit>)sequence, string3, string4, date);
    }

    public final void checkDirty$git_semver_plugin(boolean noDirtyCheck, boolean isClean) {
        if (!(noDirtyCheck || isClean)) {
            boolean bl = false;
            String string = "Local modifications exists";
            throw new IllegalStateException(string.toString());
        }
    }

    private final ObjectId getObjectIdFromRef(Repository repository, Ref ref) {
        ObjectId objectId = repository.getRefDatabase().peel(ref).getPeeledObjectId();
        if (objectId == null) {
            ObjectId objectId2 = ref.getObjectId();
            objectId = objectId2;
            Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"getObjectId(...)");
        }
        return objectId;
    }

    public static final /* synthetic */ Commit access$getCommit(GitProvider $this, RevCommit commit, RevWalk revWalk) {
        return $this.getCommit(commit, revWalk);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit/semver/plugin/scm/GitProvider$Companion;", "", "()V", "REF_PREFIX", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isFormatEnabled", "", "flag", "format", "isFormatEnabled$git_semver_plugin", "git-semver-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isFormatEnabled$git_semver_plugin(boolean flag, @NotNull String format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            return flag && ((CharSequence)format).length() > 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lgit/semver/plugin/scm/GitProvider$ReleaseParams;", "", "tag", "", "commit", "preRelease", "", "message", "noDirtyCheck", "(ZZLjava/lang/String;Ljava/lang/String;Z)V", "getCommit", "()Z", "getMessage", "()Ljava/lang/String;", "getNoDirtyCheck", "getPreRelease", "getTag", "git-semver-plugin"})
    public static final class ReleaseParams {
        private final boolean tag;
        private final boolean commit;
        @Nullable
        private final String preRelease;
        @Nullable
        private final String message;
        private final boolean noDirtyCheck;

        public ReleaseParams(boolean tag, boolean commit, @Nullable String preRelease, @Nullable String message, boolean noDirtyCheck) {
            this.tag = tag;
            this.commit = commit;
            this.preRelease = preRelease;
            this.message = message;
            this.noDirtyCheck = noDirtyCheck;
        }

        public /* synthetic */ ReleaseParams(boolean bl, boolean bl2, String string, String string2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            this(bl, bl2, string, string2, bl3);
        }

        public final boolean getTag() {
            return this.tag;
        }

        public final boolean getCommit() {
            return this.commit;
        }

        @Nullable
        public final String getPreRelease() {
            return this.preRelease;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        public final boolean getNoDirtyCheck() {
            return this.noDirtyCheck;
        }
    }
}

