/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.gradle;

import git.semver.plugin.gradle.GitSemverPluginExtension;
import git.semver.plugin.scm.GitProvider;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0007J\r\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0006H\u0007J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0006H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\bH\u0007J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgit/semver/plugin/gradle/ReleaseTask;", "Lorg/gradle/api/DefaultTask;", "settings", "Lgit/semver/plugin/gradle/GitSemverPluginExtension;", "(Lgit/semver/plugin/gradle/GitSemverPluginExtension;)V", "commit", "", "message", "", "noDirtyCheck", "preRelease", "tag", "createRelease", "", "getReleaseParams", "Lgit/semver/plugin/scm/GitProvider$ReleaseParams;", "getReleaseParams$git_semver_plugin", "setCommit", "setMessage", "setNoCommit", "noCommit", "setNoDirty", "setNoTag", "noTag", "setPreRelease", "setTag", "git-semver-plugin"})
public class ReleaseTask
extends DefaultTask {
    @NotNull
    private final GitSemverPluginExtension settings;
    @Nullable
    private String preRelease;
    @Nullable
    private String message;
    private boolean tag;
    private boolean commit;
    private boolean noDirtyCheck;

    @Inject
    public ReleaseTask(@NotNull GitSemverPluginExtension settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.tag = this.settings.getCreateReleaseTag();
        this.commit = this.settings.getCreateReleaseCommit();
        this.setGroup("Versioning");
        this.setDescription("Creates a release commit and / or local tag");
    }

    @Option(option="preRelease", description="Set the current preRelease")
    public final void setPreRelease(@NotNull String preRelease) {
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        this.preRelease = preRelease;
    }

    @Option(option="message", description="Set a message for the release")
    public final void setMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
    }

    @Option(option="no-commit", description="Don't create a release commit")
    public final void setNoCommit(boolean noCommit) {
        this.commit = !noCommit;
    }

    @Option(option="commit", description="Create a release commit even if it is disabled in the settings")
    public final void setCommit(boolean commit) {
        this.commit = commit;
    }

    @Option(option="no-tag", description="Don't create a release tag")
    public final void setNoTag(boolean noTag) {
        this.tag = !noTag;
    }

    @Option(option="tag", description="Create a release tag even if it is disabled in the settings")
    public final void setTag(boolean tag) {
        this.tag = tag;
    }

    @Option(option="no-dirty", description="Don't check if repository is dirty")
    public final void setNoDirty(boolean noDirtyCheck) {
        this.noDirtyCheck = noDirtyCheck;
    }

    @TaskAction
    public final void createRelease() {
        GitProvider gitProvider = new GitProvider(this.settings.createSettings$git_semver_plugin());
        File file = ((Directory)this.settings.getGitDir$git_semver_plugin().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        gitProvider.createRelease$git_semver_plugin(file, this.getReleaseParams$git_semver_plugin());
    }

    @Internal
    @NotNull
    public final GitProvider.ReleaseParams getReleaseParams$git_semver_plugin() {
        return new GitProvider.ReleaseParams(this.tag, this.commit, this.preRelease, this.message, this.noDirtyCheck);
    }
}

