/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.semver;

import git.semver.plugin.semver.PreRelease;
import git.semver.plugin.semver.SemVersion;
import git.semver.plugin.semver.Version;
import java.io.Serializable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003JO\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010'\u001a\u00020\u0004J.\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020\u00062\b\b\u0002\u0010+\u001a\u00020#2\b\b\u0002\u0010,\u001a\u00020#J\u0006\u0010-\u001a\u00020\rJ\b\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020#R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lgit/semver/plugin/semver/SemInfoVersion;", "Ljava/io/Serializable;", "Lgit/semver/plugin/semver/Version;", "sha", "", "major", "", "minor", "patch", "preRelease", "Lgit/semver/plugin/semver/PreRelease;", "commitCount", "previousVersion", "Lgit/semver/plugin/semver/SemVersion;", "(Ljava/lang/String;IIILgit/semver/plugin/semver/PreRelease;ILgit/semver/plugin/semver/SemVersion;)V", "getCommitCount", "()I", "getMajor", "getMinor", "getPatch", "getPreRelease", "()Lgit/semver/plugin/semver/PreRelease;", "getPreviousVersion", "()Lgit/semver/plugin/semver/SemVersion;", "getSha", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "revisionString", "toInfoVersionString", "commitCountStringFormat", "shaLength", "v2", "appendPreReleaseLast", "toSemVersion", "toString", "toVersionString", "git-semver-plugin"})
public final class SemInfoVersion
implements Serializable,
Version {
    @NotNull
    private final String sha;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final PreRelease preRelease;
    private final int commitCount;
    @NotNull
    private final SemVersion previousVersion;

    public SemInfoVersion(@NotNull String sha, int major, int minor, int patch, @NotNull PreRelease preRelease, int commitCount, @NotNull SemVersion previousVersion) {
        Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        Intrinsics.checkNotNullParameter((Object)previousVersion, (String)"previousVersion");
        this.sha = sha;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.commitCount = commitCount;
        this.previousVersion = previousVersion;
    }

    @NotNull
    public final String getSha() {
        return this.sha;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    @NotNull
    public PreRelease getPreRelease() {
        return this.preRelease;
    }

    public final int getCommitCount() {
        return this.commitCount;
    }

    @NotNull
    public final SemVersion getPreviousVersion() {
        return this.previousVersion;
    }

    @NotNull
    public final SemVersion toSemVersion() {
        return new SemVersion(this.getMajor(), this.getMinor(), this.getPatch(), this.getPreRelease());
    }

    @NotNull
    public final String toVersionString(boolean v2) {
        return SemInfoVersion.toInfoVersionString$default(this, "", 0, v2, false, 8, null);
    }

    public static /* synthetic */ String toVersionString$default(SemInfoVersion semInfoVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return semInfoVersion.toVersionString(bl);
    }

    @NotNull
    public final String toInfoVersionString(@NotNull String commitCountStringFormat, int shaLength, boolean v2, boolean appendPreReleaseLast) {
        Intrinsics.checkNotNullParameter((Object)commitCountStringFormat, (String)"commitCountStringFormat");
        StringBuilder builder = new StringBuilder().append(this.getMajor()).append('.').append(this.getMinor()).append('.').append(this.getPatch());
        if (v2) {
            String shaTake;
            if (this.isPreRelease() && !appendPreReleaseLast) {
                builder.append('-').append(this.getPreRelease());
            }
            int metaSeparator = 43;
            if (this.commitCount > 0 && ((CharSequence)commitCountStringFormat).length() > 0) {
                StringBuilder stringBuilder = builder.append((char)metaSeparator);
                String string = commitCountStringFormat;
                Object[] objectArray = new Object[]{this.commitCount};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                stringBuilder.append(string2);
                metaSeparator = 46;
            }
            if (((CharSequence)(shaTake = StringsKt.take((String)this.sha, (int)shaLength))).length() > 0) {
                builder.append((char)metaSeparator).append("sha.").append(shaTake);
            }
            if (this.isPreRelease() && appendPreReleaseLast) {
                builder.append('-').append(this.getPreRelease());
            }
        } else if (this.isPreRelease()) {
            CharSequence charSequence = this.getPreRelease().getPrefix();
            Regex regex = new Regex("[^0-9A-Za-z-]");
            String string = "";
            StringBuilder stringBuilder = builder.append("-").append(regex.replace(charSequence, string));
            Object object = this.getPreRelease().getNumber();
            if (object == null) {
                object = "";
            }
            stringBuilder.append(object);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toInfoVersionString$default(SemInfoVersion semInfoVersion, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "%03d";
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return semInfoVersion.toInfoVersionString(string, n, bl, bl2);
    }

    @NotNull
    public String toString() {
        return SemInfoVersion.toInfoVersionString$default(this, null, 7, false, false, 13, null);
    }

    @NotNull
    public final String revisionString() {
        return "" + this.previousVersion.getMajor() + '.' + this.previousVersion.getMinor() + '.' + this.previousVersion.getPatch() + '.' + this.commitCount;
    }

    @Override
    public boolean isPreRelease() {
        return Version.DefaultImpls.isPreRelease(this);
    }

    @NotNull
    public final String component1() {
        return this.sha;
    }

    public final int component2() {
        return this.major;
    }

    public final int component3() {
        return this.minor;
    }

    public final int component4() {
        return this.patch;
    }

    @NotNull
    public final PreRelease component5() {
        return this.preRelease;
    }

    public final int component6() {
        return this.commitCount;
    }

    @NotNull
    public final SemVersion component7() {
        return this.previousVersion;
    }

    @NotNull
    public final SemInfoVersion copy(@NotNull String sha, int major, int minor, int patch, @NotNull PreRelease preRelease, int commitCount, @NotNull SemVersion previousVersion) {
        Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        Intrinsics.checkNotNullParameter((Object)previousVersion, (String)"previousVersion");
        return new SemInfoVersion(sha, major, minor, patch, preRelease, commitCount, previousVersion);
    }

    public static /* synthetic */ SemInfoVersion copy$default(SemInfoVersion semInfoVersion, String string, int n, int n2, int n3, PreRelease preRelease, int n4, SemVersion semVersion, int n5, Object object) {
        if ((n5 & 1) != 0) {
            string = semInfoVersion.sha;
        }
        if ((n5 & 2) != 0) {
            n = semInfoVersion.major;
        }
        if ((n5 & 4) != 0) {
            n2 = semInfoVersion.minor;
        }
        if ((n5 & 8) != 0) {
            n3 = semInfoVersion.patch;
        }
        if ((n5 & 0x10) != 0) {
            preRelease = semInfoVersion.preRelease;
        }
        if ((n5 & 0x20) != 0) {
            n4 = semInfoVersion.commitCount;
        }
        if ((n5 & 0x40) != 0) {
            semVersion = semInfoVersion.previousVersion;
        }
        return semInfoVersion.copy(string, n, n2, n3, preRelease, n4, semVersion);
    }

    public int hashCode() {
        int result = this.sha.hashCode();
        result = result * 31 + Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        result = result * 31 + this.preRelease.hashCode();
        result = result * 31 + Integer.hashCode(this.commitCount);
        result = result * 31 + this.previousVersion.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemInfoVersion)) {
            return false;
        }
        SemInfoVersion semInfoVersion = (SemInfoVersion)other;
        if (!Intrinsics.areEqual((Object)this.sha, (Object)semInfoVersion.sha)) {
            return false;
        }
        if (this.major != semInfoVersion.major) {
            return false;
        }
        if (this.minor != semInfoVersion.minor) {
            return false;
        }
        if (this.patch != semInfoVersion.patch) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preRelease, (Object)semInfoVersion.preRelease)) {
            return false;
        }
        if (this.commitCount != semInfoVersion.commitCount) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.previousVersion, (Object)semInfoVersion.previousVersion);
    }
}

