/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.semver;

import git.semver.plugin.scm.IRefInfo;
import git.semver.plugin.semver.MutableSemVersion;
import git.semver.plugin.semver.PreRelease;
import git.semver.plugin.semver.SemInfoVersion;
import git.semver.plugin.semver.SemVersion;
import git.semver.plugin.semver.SemverSettings;
import git.semver.plugin.semver.Version;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 L2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001LB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\u001d\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b0J\u0018\u00101\u001a\u00020+2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0002J\u0011\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\u0000H\u0096\u0002J\u001b\u00107\u001a\u00020\u00002\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000009H\u0000\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020+H\u0002J\u0017\u0010$\u001a\u00020+2\b\u0010<\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b=J\u0006\u0010>\u001a\u00020?J'\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020B2\u0006\u00102\u001a\u0002032\b\u0010C\u001a\u0004\u0018\u00010\u0000H\u0000\u00a2\u0006\u0002\bDJ\u0010\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u00020\tH\u0002J\u0010\u0010G\u001a\u00020+2\u0006\u0010F\u001a\u00020\tH\u0002J\u0010\u0010H\u001a\u00020+2\u0006\u0010F\u001a\u00020\tH\u0002J\u001c\u0010I\u001a\u00020+2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0KH\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R\u001a\u0010\u001a\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0012R\u001a\u0010\u001d\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0010\"\u0004\b\u001f\u0010\u0012R\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006M"}, d2={"Lgit/semver/plugin/semver/MutableSemVersion;", "", "Lgit/semver/plugin/semver/Version;", "()V", "sha", "", "initialVersion", "Lgit/semver/plugin/semver/SemVersion;", "commitCount", "", "(Ljava/lang/String;Lgit/semver/plugin/semver/SemVersion;I)V", "bumpMajor", "bumpMinor", "bumpPatch", "bumpPre", "getCommitCount", "()I", "setCommitCount", "(I)V", "hasPendingChanges", "", "getHasPendingChanges", "()Z", "major", "getMajor", "setMajor", "minor", "getMinor", "setMinor", "patch", "getPatch", "setPatch", "preRelease", "Lgit/semver/plugin/semver/PreRelease;", "getPreRelease", "()Lgit/semver/plugin/semver/PreRelease;", "setPreRelease", "(Lgit/semver/plugin/semver/PreRelease;)V", "getSha", "()Ljava/lang/String;", "setSha", "(Ljava/lang/String;)V", "applyChangesGrouped", "", "applyChangesNotGrouped", "applyPendingChanges", "forceBumpIfNoChanges", "groupChanges", "applyPendingChanges$git_semver_plugin", "checkCommitText", "settings", "Lgit/semver/plugin/semver/SemverSettings;", "text", "compareTo", "other", "mergeChanges", "versions", "", "mergeChanges$git_semver_plugin", "resetPendingChanges", "value", "setPreRelease$git_semver_plugin", "toSemVersion", "Lgit/semver/plugin/semver/SemInfoVersion;", "updateFromCommit", "commit", "Lgit/semver/plugin/scm/IRefInfo;", "preReleaseVersion", "updateFromCommit$git_semver_plugin", "updateMajor", "i", "updateMinor", "updatePatch", "updatePreReleaseNumber", "updateFunction", "Lkotlin/Function1;", "Companion", "git-semver-plugin"})
@SourceDebugExtension(value={"SMAP\nMutableSemVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableSemVersion.kt\ngit/semver/plugin/semver/MutableSemVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class MutableSemVersion
implements Comparable<MutableSemVersion>,
Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String sha;
    @NotNull
    private final SemVersion initialVersion;
    private int commitCount;
    private int major;
    private int minor;
    private int patch;
    @NotNull
    private PreRelease preRelease;
    private int bumpMajor;
    private int bumpMinor;
    private int bumpPatch;
    private int bumpPre;
    private static final Logger logger = LoggerFactory.getLogger(MutableSemVersion.class);
    @NotNull
    private static final String NUMERIC = "0|[1-9]\\d*";
    @NotNull
    private static final String ALPHA_NUMERIC = "[0-9a-zA-Z-]";
    @NotNull
    private static final String PRE_VERSION = "(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)";
    @NotNull
    private static final Regex semVersionPattern = new Regex("(?<Major>0|[1-9]\\d*)\\.(?<Minor>0|[1-9]\\d*)(?:\\.(?<Patch>0|[1-9]\\d*)(?:\\.(?<Revision>0|[1-9]\\d*))?)?(?:-(?<PreRelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<BuildMetadata>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?");

    public MutableSemVersion(@NotNull String sha, @NotNull SemVersion initialVersion, int commitCount) {
        Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
        Intrinsics.checkNotNullParameter((Object)initialVersion, (String)"initialVersion");
        this.sha = sha;
        this.initialVersion = initialVersion;
        this.commitCount = commitCount;
        this.major = this.initialVersion.getMajor();
        this.minor = this.initialVersion.getMinor();
        this.patch = this.initialVersion.getPatch();
        this.preRelease = this.initialVersion.getPreRelease();
    }

    @NotNull
    public final String getSha() {
        return this.sha;
    }

    public final void setSha(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sha = string;
    }

    public final int getCommitCount() {
        return this.commitCount;
    }

    public final void setCommitCount(int n) {
        this.commitCount = n;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int n) {
        this.patch = n;
    }

    @Override
    @NotNull
    public PreRelease getPreRelease() {
        return this.preRelease;
    }

    public void setPreRelease(@NotNull PreRelease preRelease) {
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"<set-?>");
        this.preRelease = preRelease;
    }

    public MutableSemVersion() {
        this("", new SemVersion(0, 0, 0, null, 8, null), 0);
    }

    public final void setPreRelease$git_semver_plugin(@Nullable String value) {
        this.setPreRelease(Companion.parsePreRelease$git_semver_plugin(value));
    }

    @Override
    public int compareTo(@NotNull MutableSemVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE, compareTo.3.INSTANCE, compareTo.4.INSTANCE, compareTo.5.INSTANCE, compareTo.6.INSTANCE, compareTo.7.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    public final void updateFromCommit$git_semver_plugin(@NotNull IRefInfo commit, @NotNull SemverSettings settings, @Nullable MutableSemVersion preReleaseVersion) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.sha = commit.getSha();
        if (preReleaseVersion != null) {
            if (preReleaseVersion.compareTo(this) >= 0) {
                this.setMajor(preReleaseVersion.getMajor());
                this.setMinor(preReleaseVersion.getMinor());
                this.setPatch(preReleaseVersion.getPatch());
                this.setPreRelease(preReleaseVersion.getPreRelease());
                this.commitCount = 0;
                this.resetPendingChanges();
                logger.debug("Version after commit(\"{}\") with pre-release: {}", (Object)commit, (Object)this);
                return;
            }
            logger.warn("Ignored given version lower than the current version: {} < {} ", (Object)preReleaseVersion, (Object)this);
        }
        ++this.commitCount;
        this.checkCommitText(settings, commit.getText());
        Object[] objectArray = new Object[]{commit, this, this.bumpMajor, this.bumpMinor, this.bumpPatch, this.bumpPre};
        logger.debug("Version after commit(\"{}\"): {} +({}.{}.{}-{})", objectArray);
    }

    private final void checkCommitText(SemverSettings settings, String text) {
        if (settings.getMajorRegex$git_semver_plugin().containsMatchIn((CharSequence)text)) {
            if (!this.isPreRelease() || this.getMajor() == this.initialVersion.getMajor()) {
                ++this.bumpMajor;
                this.bumpMinor = 0;
                this.bumpPatch = 0;
                this.bumpPre = 0;
            }
        } else if (settings.getMinorRegex$git_semver_plugin().containsMatchIn((CharSequence)text)) {
            if (!this.isPreRelease() || this.getMajor() == this.initialVersion.getMajor() && this.getMinor() == this.initialVersion.getMinor()) {
                ++this.bumpMinor;
                this.bumpPatch = 0;
                this.bumpPre = 0;
            }
        } else if (settings.getPatchRegex$git_semver_plugin().containsMatchIn((CharSequence)text)) {
            if (this.getPreRelease().getNumber() == null) {
                ++this.bumpPatch;
                this.bumpPre = 0;
            } else {
                ++this.bumpPre;
            }
        }
    }

    public final boolean applyPendingChanges$git_semver_plugin(boolean forceBumpIfNoChanges, boolean groupChanges) {
        if (this.getHasPendingChanges()) {
            if (groupChanges) {
                this.applyChangesGrouped();
            } else {
                this.applyChangesNotGrouped();
            }
            this.resetPendingChanges();
            return true;
        }
        if (!forceBumpIfNoChanges) {
            return false;
        }
        Integer preReleaseNumber = this.getPreRelease().getNumber();
        if (preReleaseNumber != null) {
            this.setPreRelease(PreRelease.copy$default(this.getPreRelease(), null, preReleaseNumber + 1, 1, null));
        } else {
            this.setPatch(this.getPatch() + 1);
        }
        return true;
    }

    private final void applyChangesNotGrouped() {
        if (this.bumpMajor > 0) {
            this.updateMajor(this.bumpMajor);
        }
        if (this.bumpMinor > 0) {
            this.updateMinor(this.bumpMinor);
        }
        if (this.bumpPatch > 0) {
            this.updatePatch(this.bumpPatch);
        }
        if (this.bumpPre > 0) {
            this.updatePreReleaseNumber((Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(this){
                final /* synthetic */ MutableSemVersion this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return it + MutableSemVersion.access$getBumpPre$p(this.this$0);
                }
            }));
        }
    }

    private final void applyChangesGrouped() {
        if (this.bumpMajor > 0) {
            this.updateMajor(1);
        } else if (this.bumpMinor > 0) {
            this.updateMinor(1);
        } else if (this.bumpPatch > 0) {
            this.updatePatch(1);
        } else {
            this.updatePreReleaseNumber((Function1<? super Integer, Integer>)((Function1)applyChangesGrouped.1.INSTANCE));
        }
    }

    private final void updateMajor(int i) {
        this.setMajor(this.getMajor() + i);
        this.setMinor(0);
        this.setPatch(0);
        this.updatePreReleaseNumber((Function1<? super Integer, Integer>)((Function1)updateMajor.1.INSTANCE));
    }

    private final void updateMinor(int i) {
        this.setMinor(this.getMinor() + i);
        this.setPatch(0);
        this.updatePreReleaseNumber((Function1<? super Integer, Integer>)((Function1)updateMinor.1.INSTANCE));
    }

    private final void updatePatch(int i) {
        this.setPatch(this.getPatch() + i);
        this.updatePreReleaseNumber((Function1<? super Integer, Integer>)((Function1)updatePatch.1.INSTANCE));
    }

    private final void updatePreReleaseNumber(Function1<? super Integer, Integer> updateFunction) {
        Integer preReleaseNumber = this.getPreRelease().getNumber();
        if (preReleaseNumber != null) {
            this.setPreRelease(PreRelease.copy$default(this.getPreRelease(), null, (Integer)updateFunction.invoke((Object)preReleaseNumber), 1, null));
        }
    }

    @NotNull
    public final MutableSemVersion mergeChanges$git_semver_plugin(@NotNull List<MutableSemVersion> versions) {
        int n;
        MutableSemVersion it;
        int n2;
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Iterable iterable = versions;
        MutableSemVersion mutableSemVersion = this;
        int n3 = 0;
        for (Object t : iterable) {
            MutableSemVersion mutableSemVersion2 = (MutableSemVersion)t;
            n2 = n3;
            boolean bl = false;
            n = it.commitCount;
            n3 = n2 + n;
        }
        mutableSemVersion.commitCount = n2 = n3;
        iterable = versions;
        mutableSemVersion = this;
        n3 = 0;
        for (Object t : iterable) {
            it = (MutableSemVersion)t;
            n2 = n3;
            boolean bl = false;
            n = it.bumpPatch;
            n3 = n2 + n;
        }
        mutableSemVersion.bumpPatch = n2 = n3;
        iterable = versions;
        mutableSemVersion = this;
        n3 = 0;
        for (Object t : iterable) {
            it = (MutableSemVersion)t;
            n2 = n3;
            boolean bl = false;
            n = it.bumpMinor;
            n3 = n2 + n;
        }
        mutableSemVersion.bumpMinor = n2 = n3;
        iterable = versions;
        mutableSemVersion = this;
        n3 = 0;
        for (Object t : iterable) {
            it = (MutableSemVersion)t;
            n2 = n3;
            boolean bl = false;
            n = it.bumpMajor;
            n3 = n2 + n;
        }
        mutableSemVersion.bumpMajor = n2 = n3;
        iterable = versions;
        mutableSemVersion = this;
        n3 = 0;
        for (Object t : iterable) {
            it = (MutableSemVersion)t;
            n2 = n3;
            boolean bl = false;
            n = it.bumpPre;
            n3 = n2 + n;
        }
        mutableSemVersion.bumpPre = n2 = n3;
        return this;
    }

    private final boolean getHasPendingChanges() {
        return this.bumpMajor + this.bumpMinor + this.bumpPatch + this.bumpPre > 0;
    }

    private final void resetPendingChanges() {
        this.bumpMajor = 0;
        this.bumpMinor = 0;
        this.bumpPatch = 0;
        this.bumpPre = 0;
    }

    @NotNull
    public final SemInfoVersion toSemVersion() {
        return new SemInfoVersion(this.sha, this.getMajor(), this.getMinor(), this.getPatch(), this.getPreRelease(), this.commitCount, this.initialVersion);
    }

    @Override
    public boolean isPreRelease() {
        return Version.DefaultImpls.isPreRelease(this);
    }

    public static final /* synthetic */ int access$getBumpPre$p(MutableSemVersion $this) {
        return $this.bumpPre;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0017\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit/semver/plugin/semver/MutableSemVersion$Companion;", "", "()V", "ALPHA_NUMERIC", "", "NUMERIC", "PRE_VERSION", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "semVersionPattern", "Lkotlin/text/Regex;", "isRelease", "", "commit", "Lgit/semver/plugin/scm/IRefInfo;", "settings", "Lgit/semver/plugin/semver/SemverSettings;", "parsePreRelease", "Lgit/semver/plugin/semver/PreRelease;", "value", "parsePreRelease$git_semver_plugin", "tryParse", "Lgit/semver/plugin/semver/MutableSemVersion;", "refInfo", "git-semver-plugin"})
    @SourceDebugExtension(value={"SMAP\nMutableSemVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableSemVersion.kt\ngit/semver/plugin/semver/MutableSemVersion$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,256:1\n141#2:257\n130#2,5:258\n*S KotlinDebug\n*F\n+ 1 MutableSemVersion.kt\ngit/semver/plugin/semver/MutableSemVersion$Companion\n*L\n58#1:257\n58#1:258,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MutableSemVersion tryParse(@NotNull IRefInfo refInfo) {
            Intrinsics.checkNotNullParameter((Object)refInfo, (String)"refInfo");
            MatchResult matchResult = Regex.find$default((Regex)semVersionPattern, (CharSequence)refInfo.getText(), (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            MutableSemVersion version2 = new MutableSemVersion(refInfo.getSha(), new SemVersion(git.semver.plugin.semver.MutableSemVersion$Companion.tryParse$getIntValue(match, "Major"), git.semver.plugin.semver.MutableSemVersion$Companion.tryParse$getIntValue(match, "Minor"), git.semver.plugin.semver.MutableSemVersion$Companion.tryParse$getIntValue(match, "Patch"), this.parsePreRelease$git_semver_plugin(git.semver.plugin.semver.MutableSemVersion$Companion.tryParse$getValue(match, "PreRelease"))), git.semver.plugin.semver.MutableSemVersion$Companion.tryParse$getIntValue(match, "Revision"));
            logger.debug("Found version: {} in: '{}'", (Object)version2, (Object)refInfo.getText());
            return version2;
        }

        @NotNull
        public final PreRelease parsePreRelease$git_semver_plugin(@Nullable String value) {
            Integer n;
            CharSequence charSequence;
            block5: {
                if (value == null) {
                    return PreRelease.Companion.getNoPreRelease();
                }
                String $this$trimEnd$iv = value;
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n2 = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv$iv = n2--;
                        char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (Character.isDigit(it)) continue;
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block5;
                    } while (0 <= n2);
                }
                charSequence = "";
            }
            String prefix = ((Object)charSequence).toString();
            if (prefix.length() < value.length()) {
                String string = value.substring(prefix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                n = Integer.parseInt(string);
            } else {
                n = null;
            }
            return new PreRelease(prefix, n);
        }

        public final boolean isRelease(@NotNull IRefInfo commit, @NotNull SemverSettings settings) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return settings.getReleaseRegex$git_semver_plugin().containsMatchIn((CharSequence)commit.getText());
        }

        private static final String tryParse$getValue(MatchResult match, String group) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)group);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        private static final int tryParse$getIntValue(MatchResult match, String group) {
            String string = git.semver.plugin.semver.MutableSemVersion$Companion.tryParse$getValue(match, group);
            return string != null ? Integer.parseInt(string) : 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

