/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.io;

import com.github.jlgrock.javascriptframework.mavenutils.io.DirectoryIO;
import com.github.jlgrock.javascriptframework.mavenutils.io.readers.FilteredReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class FileIO {
    static final Logger LOGGER = Logger.getLogger(FileIO.class);

    private FileIO() {
    }

    public static void copyStream(InputStream from, OutputStream to) throws IOException {
        LOGGER.debug((Object)"copying stream...");
        try {
            IOUtils.copy((InputStream)from, (OutputStream)to);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"There was a problem copying the resource.");
            throw ioe;
        }
        finally {
            IOUtils.closeQuietly((InputStream)from);
            IOUtils.closeQuietly((OutputStream)to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatenateStreams(Reader[] readers, File outputFile) throws IOException {
        if (outputFile == null) {
            throw new IOException("outputFile is required for concatenation of files.");
        }
        LOGGER.debug((Object)"Begining stream concatenation");
        List<Reader> readerList = Arrays.asList(readers);
        FileWriter outWriter = null;
        DirectoryIO.createDir(outputFile.getParentFile());
        outputFile.createNewFile();
        try {
            outWriter = new FileWriter(outputFile);
            for (Reader listItem : readerList) {
                String line;
                FilteredReader fr = new FilteredReader(listItem, "\t", "    ");
                do {
                    if ((line = fr.readLine()) == null) continue;
                    outWriter.append(line + "\n");
                } while (line != null);
                listItem.close();
            }
        }
        finally {
            try {
                outWriter.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to close file.  This should not matter");
            }
        }
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        return name.substring(pos + 1);
    }

    public static String removeFileExtension(File file) {
        String name = file.getName();
        if (!name.contains(".")) {
            return name;
        }
        int pos = name.lastIndexOf(46);
        return name.substring(0, pos);
    }

    public static void changeExtension(File file, String newExtension) throws IOException {
        String newFilename = FileIO.removeFileExtension(file) + "." + newExtension;
        File file2 = new File(newFilename);
        boolean success = file.renameTo(file2);
        if (!success) {
            throw new IOException("Could not rename file from \"" + file.getName() + "\" to \"" + file2.getName() + "\".");
        }
    }
}

