/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.jsdependency;

import com.github.jlgrock.javascriptframework.jsdependency.AbstractDependencyMojo;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.ArtifactExtractor;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.JsarRelativeLocations;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.PackagingType;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.ScopeType;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public final class JsarWarDependencyMojo
extends AbstractDependencyMojo {
    private MavenProject project;
    private static final Logger LOGGER = Logger.getLogger(JsarWarDependencyMojo.class);
    private boolean extractDebug;
    private boolean extractAssert;
    private boolean extractCompiled;
    private boolean includeRequiresFiles;
    private File frameworkTargetDirectory;
    private File compiledFileDirectory;

    @Override
    protected void extractDependencies() throws IOException, MojoFailureException, MojoExecutionException {
        File location = JsarRelativeLocations.getOutputLocation((File)this.getFrameworkTargetDirectory());
        Set<Artifact> artifactSet = this.getArtifactSet();
        this.extractInterns(this.extractAssert);
        this.extractExterns(artifactSet);
        ArtifactExtractor extractJSArtifacts = new ArtifactExtractor(artifactSet);
        if (!this.isSkipGoogleExtraction()) {
            this.extractAndRenameLibrary();
        }
        Set artifactSetNonTransitive = this.getProject().getDependencyArtifacts();
        extractJSArtifacts = new ArtifactExtractor(artifactSetNonTransitive);
        if (this.extractAssert) {
            extractJSArtifacts.extract("assert/", PackagingType.JSAR, ScopeType.ANY, location);
            extractJSArtifacts.extract("assertionSource/", PackagingType.JSAR, ScopeType.ANY, location);
            extractJSArtifacts.extract("assertRequires/", PackagingType.JSAR, ScopeType.ANY, location);
        }
        extractJSArtifacts.extract("debug/", PackagingType.JSAR, ScopeType.ANY, location);
        extractJSArtifacts.extract("debugSource/", PackagingType.JSAR, ScopeType.ANY, location);
        extractJSArtifacts.extract("debugRequires/", PackagingType.JSAR, ScopeType.ANY, location);
        if (this.compiledFileDirectory != null) {
            throw new MojoExecutionException("compiledFileDirectory is no longer an accepted parameter.  Please remove.  This will now be located within the frameworkTargetDirectory");
        }
        if (this.extractCompiled) {
            LOGGER.info((Object)("Extracting compiled dependencies to location \"" + location.getAbsolutePath() + "\""));
            extractJSArtifacts.extract("compiled/", PackagingType.JSAR, ScopeType.ANY, location);
        }
    }

    @Override
    public File getFrameworkTargetDirectory() {
        return this.frameworkTargetDirectory;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public Set<Artifact> getArtifactSet() {
        Set artifactSet = this.getProject().getArtifacts();
        return artifactSet;
    }
}

