/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.closuretesting;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.github.jlgrock.javascriptframework.closuretesting.AbstractClosureTestingMojo;
import com.github.jlgrock.javascriptframework.closuretesting.resultparsing.ParseRunner;
import com.github.jlgrock.javascriptframework.closuretesting.resultparsing.TestResultType;
import com.github.jlgrock.javascriptframework.closuretesting.resultparsing.TestUnitDriver;
import com.github.jlgrock.javascriptframework.closuretesting.resultparsing.generators.SuiteGenerator;
import com.github.jlgrock.javascriptframework.closuretesting.resultparsing.testingcomponents.TestCase;
import com.github.jlgrock.javascriptframework.mavenutils.io.DirectoryIO;
import com.github.jlgrock.javascriptframework.mavenutils.logging.MojoLogAppender;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.JsarRelativeLocations;
import com.github.jlgrock.javascriptframework.mavenutils.pathing.FileListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="js-closure-test", defaultPhase=LifecyclePhase.TEST)
public class ClosureTestingMojo
extends AbstractClosureTestingMojo {
    private static final Logger LOGGER = Logger.getLogger(ClosureTestingMojo.class);

    @Override
    public final void execute() throws MojoExecutionException, MojoFailureException {
        MojoLogAppender.beginLogging((AbstractMojo)this);
        try {
            if (!this.isSkip()) {
                List<File> files = this.generateFiles();
                if (!this.isSkipTests()) {
                    List<TestCase> testCases = ClosureTestingMojo.parseFiles(files, this.getMaximumFailures(), this.getTestTimeoutSeconds(), this.getMaxTestThreads(), this.getBrowserVersion());
                    if (testCases.size() > 0) {
                        this.printFailures(testCases);
                        throw new MojoFailureException("There were test case failures.");
                    }
                } else {
                    LOGGER.info((Object)"Test executions are skipped.");
                }
            } else {
                LOGGER.info((Object)"Tests are skipped.");
            }
        }
        catch (MojoFailureException mje) {
            throw mje;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            MojoLogAppender.endLogging();
        }
    }

    private void printFailures(List<TestCase> testCases) {
        StringBuffer sb = new StringBuffer();
        for (TestCase testCase : testCases) {
            if (testCase.getResult().equals((Object)TestResultType.PASSED)) continue;
            sb.append(testCase.toString());
        }
        LOGGER.error((Object)sb.toString());
    }

    private List<File> generateFiles() throws IOException {
        File testOutputDir = JsarRelativeLocations.getTestSuiteLocation((File)this.getFrameworkTargetDirectory());
        File testDepsDir = JsarRelativeLocations.getTestLocation((File)this.getFrameworkTargetDirectory());
        File depsFileLocation = JsarRelativeLocations.getTestDepsLocation((File)this.getFrameworkTargetDirectory());
        ArrayList<File> returnFiles = new ArrayList<File>();
        DirectoryIO.recursivelyDeleteDirectory((File)testOutputDir);
        File baseLocation = new File(this.getClosureLibraryLocation().getAbsoluteFile() + File.separator + "closure" + File.separator + "goog" + File.separator + "base.js");
        LOGGER.info((Object)"Generating Test Suite...");
        List<File> fileSet = this.calculateFileSet();
        List testDeps = FileListBuilder.buildFilteredList((File)testDepsDir, (String)"js");
        List depsFileSet = FileListBuilder.buildFilteredList((File)depsFileLocation, (String)"js");
        File depsFile = null;
        if (depsFileSet.size() != 1) {
            throw new IOException("Could not find debug/deps file (or found more than one) at location '" + depsFileLocation + "'.");
        }
        depsFile = depsFileSet.toArray(new File[depsFileSet.size()])[0];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Files that will be included in testing:" + fileSet));
            LOGGER.debug((Object)("Base Location:" + baseLocation));
            LOGGER.debug((Object)("calc deps Location:" + depsFile));
            LOGGER.debug((Object)("Testing Dependency Location:" + testDepsDir));
            LOGGER.debug((Object)("Testing Source Directory:" + this.getTestSourceDirectory()));
        }
        SuiteGenerator suite = new SuiteGenerator(fileSet, baseLocation, depsFile, testDeps, this.getPreamble(), this.getPrologue(), this.getEpilogue());
        Set testFiles = suite.generateTestFiles(this.getTestSourceDirectory(), testOutputDir);
        returnFiles.addAll(testFiles);
        if (this.isRunTestsOnCompiled()) {
            File testCompiledOutputDir = JsarRelativeLocations.getCompiledTestSuiteLocation((File)this.getFrameworkTargetDirectory());
            File compiledFile = new File(JsarRelativeLocations.getCompileLocation((File)this.getFrameworkTargetDirectory()), this.getCompiledFilename());
            SuiteGenerator suiteCompiled = new SuiteGenerator(fileSet, baseLocation, compiledFile, testDeps, this.getPreamble(), this.getPrologue(), this.getEpilogue());
            returnFiles.addAll(suiteCompiled.generateTestFiles(this.getTestSourceDirectory(), testCompiledOutputDir));
        }
        for (File file : returnFiles) {
            LOGGER.debug((Object)("filename: " + file.getAbsolutePath()));
        }
        LOGGER.debug((Object)("baseLocation: " + baseLocation.getAbsolutePath()));
        LOGGER.debug((Object)("testOutputDir: " + testOutputDir.getAbsolutePath()));
        return returnFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TestCase> parseFiles(List<File> files, final int maxFailures, long testTimeoutSeconds, int maxThreads, String browserVersion) {
        ArrayList<TestCase> failures = new ArrayList<TestCase>();
        int fileCount = files != null ? files.size() : 0;
        int threadCount = Math.min(fileCount, maxThreads);
        LOGGER.info((Object)String.format("Parsing %d Test Files (%d threads)...", fileCount, threadCount));
        if (fileCount > 0) {
            final List syncFailures = Collections.synchronizedList(failures);
            ExecutorService threadPool = maxThreads > 1 ? Executors.newFixedThreadPool(threadCount) : Executors.newSingleThreadExecutor();
            final ArrayBlockingQueue<ParseRunner> runnerQueue = new ArrayBlockingQueue<ParseRunner>(threadCount);
            BrowserVersion bv = TestUnitDriver.getBrowserVersionSafe((String)browserVersion);
            LOGGER.debug((Object)("HtmlUnit browser version: " + bv.getNickname()));
            for (int idx = 0; idx < threadCount; ++idx) {
                runnerQueue.add(new ParseRunner(new TestUnitDriver(true, bv), testTimeoutSeconds));
            }
            final CountDownLatch latch = new CountDownLatch(fileCount);
            for (final File file : files) {
                Callable<Void> testTask = new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        block12: {
                            if (maxFailures > 0) {
                                List list = syncFailures;
                                synchronized (list) {
                                    if (syncFailures.size() > maxFailures) {
                                        latch.countDown();
                                        return null;
                                    }
                                }
                            }
                            ParseRunner runner = (ParseRunner)runnerQueue.take();
                            try {
                                TestCase testCase = runner.parseFile(file);
                                if (TestResultType.PASSED.equals((Object)testCase.getResult())) break block12;
                                List list = syncFailures;
                                synchronized (list) {
                                    syncFailures.add(testCase);
                                }
                            }
                            finally {
                                if (runner != null) {
                                    runnerQueue.put(runner);
                                }
                                latch.countDown();
                            }
                        }
                        return null;
                    }
                };
                threadPool.submit(testTask);
            }
            threadPool.shutdown();
            try {
                latch.await();
            }
            catch (InterruptedException ie) {
                threadPool.shutdownNow();
            }
            finally {
                if (runnerQueue.size() != threadCount) {
                    throw new IllegalStateException("ParseRunners were not properly returned to the queue.");
                }
                while (!runnerQueue.isEmpty()) {
                    ((ParseRunner)runnerQueue.remove()).quit();
                }
            }
        }
        return failures;
    }

    private List<File> calculateFileSet() {
        LOGGER.info((Object)"Calculating File Set...");
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(FileListBuilder.buildFilteredList((File)this.getTestSourceDirectory(), (String)"js"));
        if (this.getIncludes() != null) {
            files.addAll(this.getIncludes());
        }
        if (this.getExcludes() != null) {
            files.removeAll(this.getExcludes());
        }
        return files;
    }
}

