/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.timeandspace.cronscheduler;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.repackage.io.timeandspace.cronscheduler.CronScheduler;
import org.repackage.io.timeandspace.cronscheduler.OneShotTasksShutdownPolicy;
import org.repackage.io.timeandspace.cronscheduler.OverwritingThreadFactory;
import org.repackage.io.timeandspace.cronscheduler.RejectedExecutionHandler;
import org.repackage.io.timeandspace.cronscheduler.ScheduledThreadPoolExecutor;

abstract class ThreadPoolExecutor {
    private static final Object WORKER_MUST_EXIT = new Object();
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
    private static final int COUNT_BITS = 29;
    private static final int COUNT_MASK = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    final Clock timeProvider;
    private final long syncPeriodNanos;
    private final Consumer<String> backwardTimeShiftLogger;
    private final ScheduledThreadPoolExecutor.DelayedWorkQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler = AbortPolicy.INSTANCE;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;

    private static int workerCountOf(int c) {
        return c & 0x1FFFFFFF;
    }

    private static int ctlOf(int rs, int wc) {
        return rs | wc;
    }

    private static boolean runStateLessThan(int c, int s) {
        return c < s;
    }

    private static boolean runStateAtLeast(int c, int s) {
        return c >= s;
    }

    private static boolean isRunning(int c) {
        return c < 0;
    }

    private boolean compareAndIncrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect + 1);
    }

    private void decrementWorkerCount() {
        this.ctl.addAndGet(-1);
    }

    private void advanceRunState(int targetState) {
        int c;
        while (!ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), targetState) && !this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(targetState, ThreadPoolExecutor.workerCountOf(c)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int c;
        while (!(ThreadPoolExecutor.isRunning(c = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(c, 0x40000000) || ThreadPoolExecutor.runStateLessThan(c, 0x20000000) && !this.workQueue.isEmpty())) {
            if (ThreadPoolExecutor.workerCountOf(c) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (!this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(0x40000000, 0))) continue;
                try {
                    this.terminated();
                }
                finally {
                    this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                    this.termination.signalAll();
                }
                return;
            }
            finally {
                mainLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
            for (Worker w : this.workers) {
                security.checkAccess(w.thread);
            }
        }
    }

    private void interruptWorkers() {
        for (Worker w : this.workers) {
            w.interruptIfStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                Thread t = w.thread;
                if (!t.isInterrupted() && w.tryLock()) {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException securityException) {
                    }
                    finally {
                        w.unlock();
                    }
                }
                if (!onlyOne) continue;
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    final void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    void onShutdown(OneShotTasksShutdownPolicy oneShotTasksShutdownPolicy) {
    }

    private List<Future<?>> drainQueue() {
        ScheduledThreadPoolExecutor.DelayedWorkQueue q = this.workQueue;
        ArrayList<ScheduledThreadPoolExecutor.ScheduledFutureTask> taskList = new ArrayList<ScheduledThreadPoolExecutor.ScheduledFutureTask>();
        q.drainTo(taskList);
        if (!q.isEmpty()) {
            for (ScheduledThreadPoolExecutor.ScheduledFutureTask r : q.toArray(new ScheduledThreadPoolExecutor.ScheduledFutureTask[0])) {
                if (!q.remove(r)) continue;
                taskList.add(r);
            }
        }
        return Collections.unmodifiableList(taskList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable firstTask, boolean core) {
        boolean workerStarted;
        block15: {
            int c = this.ctl.get();
            block6: while (true) {
                if (ThreadPoolExecutor.runStateAtLeast(c, 0) && (ThreadPoolExecutor.runStateAtLeast(c, 0x20000000) || firstTask != null || this.workQueue.isEmpty())) {
                    return false;
                }
                do {
                    if (ThreadPoolExecutor.workerCountOf(c) >= ((core ? this.corePoolSize : this.maximumPoolSize) & 0x1FFFFFFF)) {
                        return false;
                    }
                    if (this.compareAndIncrementWorkerCount(c)) break block6;
                } while (!ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), 0));
            }
            workerStarted = false;
            boolean workerAdded = false;
            Worker w = null;
            try {
                w = new Worker(firstTask);
                Thread t = w.thread;
                if (t == null) break block15;
                ReentrantLock mainLock = this.mainLock;
                mainLock.lock();
                try {
                    int c2 = this.ctl.get();
                    if (ThreadPoolExecutor.isRunning(c2) || ThreadPoolExecutor.runStateLessThan(c2, 0x20000000) && firstTask == null) {
                        if (t.getState() != Thread.State.NEW) {
                            throw new IllegalThreadStateException();
                        }
                        this.workers.add(w);
                        workerAdded = true;
                        int s = this.workers.size();
                        if (s > this.largestPoolSize) {
                            this.largestPoolSize = s;
                        }
                    }
                }
                finally {
                    mainLock.unlock();
                }
                if (workerAdded) {
                    t.start();
                    workerStarted = true;
                }
            }
            finally {
                if (!workerStarted) {
                    this.addWorkerFailed(w);
                }
            }
        }
        return workerStarted;
    }

    private void addWorkerFailed(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (w != null) {
                this.workers.remove(w);
            }
            this.decrementWorkerCount();
            this.tryTerminate();
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker w, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        int c = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(c, 0x20000000)) {
            if (!completedAbruptly) {
                int min = this.corePoolSize;
                if (min == 0 && !this.workQueue.isEmpty()) {
                    min = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(c) >= min) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Object getTask() {
        long startNanos = System.nanoTime();
        long elapsedNanos = 0L;
        while (true) {
            int c;
            if (ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), 0) && (ThreadPoolExecutor.runStateAtLeast(c, 0x20000000) || this.workQueue.isEmpty())) {
                this.decrementWorkerCount();
                return WORKER_MUST_EXIT;
            }
            try {
                return this.workQueue.poll(this.syncPeriodNanos - elapsedNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException retry) {
                if ((elapsedNanos = System.nanoTime() - startNanos) < this.syncPeriodNanos) continue;
                return null;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker w) {
        Thread wt = Thread.currentThread();
        Object taskOrExitMarker = w.firstTask;
        w.firstTask = null;
        w.unlock();
        long prevCurrentTimeMillis = this.timeProvider.millis();
        boolean completedAbruptly = true;
        try {
            while (taskOrExitMarker != null || (taskOrExitMarker = this.getTask()) != WORKER_MUST_EXIT) {
                long newCurrentTimeMillis;
                boolean shiftedTimeBackward;
                Object task = taskOrExitMarker;
                if (task != null) {
                    w.lock();
                    if ((ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000) || Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) && !wt.isInterrupted()) {
                        wt.interrupt();
                    }
                    try {
                        this.beforeExecute(wt, (Runnable)task);
                        try {
                            task.run();
                            this.afterExecute((Runnable)task, null);
                        }
                        catch (Throwable ex) {
                            this.afterExecute((Runnable)task, ex);
                            throw ex;
                        }
                    }
                    finally {
                        taskOrExitMarker = null;
                        ++w.completedTasks;
                        w.unlock();
                    }
                }
                boolean bl = shiftedTimeBackward = (newCurrentTimeMillis = this.timeProvider.millis()) < prevCurrentTimeMillis;
                if (shiftedTimeBackward) {
                    String message = wt.toString() + " detected backward time shift from " + Instant.ofEpochMilli(prevCurrentTimeMillis) + " to " + Instant.ofEpochMilli(newCurrentTimeMillis);
                    this.backwardTimeShiftLogger.accept(message);
                    this.workQueue.rebuild(newCurrentTimeMillis);
                }
                prevCurrentTimeMillis = newCurrentTimeMillis;
            }
            completedAbruptly = false;
        }
        finally {
            this.processWorkerExit(w, completedAbruptly);
        }
    }

    public ThreadPoolExecutor(Clock timeProvider, Duration syncPeriod, ScheduledThreadPoolExecutor.DelayedWorkQueue workQueue, ThreadFactory threadFactory, Consumer<String> backwardTimeShiftLogger) {
        Objects.requireNonNull(timeProvider);
        CronScheduler.checkSyncPeriod(syncPeriod);
        Objects.requireNonNull(workQueue);
        Objects.requireNonNull(threadFactory);
        Objects.requireNonNull(backwardTimeShiftLogger);
        this.timeProvider = timeProvider;
        this.syncPeriodNanos = syncPeriod.toNanos();
        this.corePoolSize = 1;
        this.maximumPoolSize = 1;
        this.workQueue = workQueue;
        this.threadFactory = threadFactory;
        this.backwardTimeShiftLogger = backwardTimeShiftLogger;
    }

    void shutdown(OneShotTasksShutdownPolicy oneShotTasksShutdownPolicy) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown(oneShotTasksShutdownPolicy);
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
    }

    List<Future<?>> shutdownNow() {
        List<Future<?>> tasks;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            tasks = this.drainQueue();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        return tasks;
    }

    public boolean isShutdown() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0);
    }

    public boolean isTerminating() {
        int c = this.ctl.get();
        return ThreadPoolExecutor.runStateAtLeast(c, 0) && ThreadPoolExecutor.runStateLessThan(c, 0x60000000);
    }

    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (ThreadPoolExecutor.runStateLessThan(this.ctl.get(), 0x60000000)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public boolean prestartThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    void ensurePrestart() {
        int wc = ThreadPoolExecutor.workerCountOf(this.ctl.get());
        if (wc < this.corePoolSize) {
            this.addWorker(null, true);
        } else if (wc == 0) {
            this.addWorker(null, false);
        }
    }

    ScheduledThreadPoolExecutor.DelayedWorkQueue getQueueInternal() {
        return this.workQueue;
    }

    boolean remove(ScheduledThreadPoolExecutor.ScheduledFutureTask<?> task) {
        boolean removed = this.workQueue.remove(task);
        this.tryTerminate();
        return removed;
    }

    public void purge() {
        ScheduledThreadPoolExecutor.DelayedWorkQueue q = this.workQueue;
        try {
            Iterator<ScheduledThreadPoolExecutor.ScheduledFutureTask<?>> it = q.iterator();
            while (it.hasNext()) {
                Runnable r = it.next();
                if (!((Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException fallThrough) {
            for (ScheduledThreadPoolExecutor.ScheduledFutureTask t : q.toArray(new ScheduledThreadPoolExecutor.ScheduledFutureTask[0])) {
                if (!t.isCancelled()) continue;
                q.remove(t);
            }
        }
        this.tryTerminate();
    }

    public boolean isThreadRunning() {
        return this.getPoolSize() > 0;
    }

    private int getPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    public boolean isThreadActive() {
        return this.getActiveCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
                if (!w.isLocked()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int c;
        int nworkers;
        int nactive;
        long ncompleted;
        String name = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            ncompleted = this.completedTaskCount;
            nactive = 0;
            nworkers = this.workers.size();
            for (Worker w : this.workers) {
                ncompleted += w.completedTasks;
                if (w.isLocked()) {
                    ++nactive;
                }
                name = w.thread.getName();
            }
        }
        finally {
            mainLock.unlock();
        }
        if (name == null && this.threadFactory instanceof OverwritingThreadFactory) {
            name = ((OverwritingThreadFactory)this.threadFactory).name;
        }
        String runState = ThreadPoolExecutor.isRunning(c = this.ctl.get()) ? "Running" : (ThreadPoolExecutor.runStateAtLeast(c, 0x60000000) ? "Terminated" : "Shutting down");
        return super.toString() + (name != null ? "[" + name + "]" : "") + "[" + runState + ", thread started = " + (nworkers > 0) + ", thread active = " + (nactive > 0) + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + ncompleted + "]";
    }

    private void beforeExecute(Thread t, Runnable r) {
    }

    private void afterExecute(Runnable r, Throwable t) {
    }

    private void terminated() {
    }

    static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    static class AbortPolicy
    implements RejectedExecutionHandler {
        static final AbortPolicy INSTANCE = new AbortPolicy();

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
        }
    }

    static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private final class Worker
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable firstTask) {
            this.setState(-1);
            this.firstTask = firstTask;
            this.thread = ThreadPoolExecutor.this.threadFactory.newThread(this);
        }

        @Override
        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int unused) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int unused) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        public void lock() {
            this.acquire(1);
        }

        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        public void unlock() {
            this.release(1);
        }

        public boolean isLocked() {
            return this.isHeldExclusively();
        }

        void interruptIfStarted() {
            Thread t;
            if (this.getState() >= 0 && (t = this.thread) != null && !t.isInterrupted()) {
                try {
                    t.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }
}

