/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.timeandspace.cronscheduler;

import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.repackage.io.timeandspace.cronscheduler.CronScheduler;
import org.repackage.io.timeandspace.cronscheduler.DefaultCronSchedulerThreadFactory;
import org.repackage.io.timeandspace.cronscheduler.OverwritingThreadFactory;

public class CronSchedulerBuilder {
    private final Duration syncPeriod;
    @Nullable
    private Integer threadPriority = null;
    @Nullable
    private String threadName = null;
    private ThreadFactory threadFactory = DefaultCronSchedulerThreadFactory.INSTANCE;
    private Clock timeProvider = Clock.systemUTC();
    private Consumer<String> backwardTimeShiftLogger = CronScheduler.DEFAULT_BACKWARD_TIME_SHIFT_LOGGER;

    CronSchedulerBuilder(Duration syncPeriod) {
        CronScheduler.checkSyncPeriod(syncPeriod);
        this.syncPeriod = syncPeriod;
    }

    public CronSchedulerBuilder setThreadPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException(String.format("Priority is outside of allowed range [%d, %d]: %d", 1, 10, priority));
        }
        this.threadPriority = priority;
        return this;
    }

    public CronSchedulerBuilder setThreadName(String threadName) {
        Objects.requireNonNull(threadName);
        this.threadName = threadName;
        return this;
    }

    public CronSchedulerBuilder setThreadFactory(ThreadFactory factory) {
        Objects.requireNonNull(factory);
        this.threadFactory = factory;
        return this;
    }

    public CronSchedulerBuilder setTimeProvider(Clock timeProvider) {
        Objects.requireNonNull(timeProvider);
        this.timeProvider = timeProvider;
        return this;
    }

    public CronScheduler build() {
        return new CronScheduler(this);
    }

    public CronSchedulerBuilder setBackwardTimeShiftLogger(Consumer<String> logger) {
        Objects.requireNonNull(logger);
        this.backwardTimeShiftLogger = logger;
        return this;
    }

    Clock getTimeProvider() {
        return this.timeProvider;
    }

    Duration getSyncPeriod() {
        return this.syncPeriod;
    }

    ThreadFactory getThreadFactory() {
        if (this.threadPriority != null || this.threadName != null) {
            return new OverwritingThreadFactory(this.threadFactory, this.threadPriority, this.threadName);
        }
        return this.threadFactory;
    }

    Consumer<String> getBackwardTimeShiftLogger() {
        return this.backwardTimeShiftLogger;
    }
}

