/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.util;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.repackage.com.github.jlangch.aviron.ex.AvironException;
import org.repackage.com.github.jlangch.aviron.util.DirCyclerStatistics;
import org.repackage.com.github.jlangch.aviron.util.IDirCycler;

public class DirCycler
implements IDirCycler {
    private final Object lock = new Object();
    private final File rootDir;
    private final File stateFile;
    private final List<File> subDirs = new ArrayList<File>();
    private int lastDirIdx = -1;
    private long roundtripStartTime = 0L;
    private DirCyclerStatistics statistics = new DirCyclerStatistics();

    public DirCycler(File rootDir) {
        this(rootDir, null);
    }

    public DirCycler(File rootDir, File stateFile) {
        if (rootDir == null) {
            throw new IllegalArgumentException("The rootDir must not be null!");
        }
        if (!rootDir.isDirectory()) {
            throw new RuntimeException("The rootDir does not exist or is not a directory");
        }
        this.rootDir = rootDir;
        this.stateFile = stateFile;
        this.refreshDirs();
        if (stateFile != null) {
            this.loadStateFromFile(stateFile);
        }
    }

    @Override
    public File rootDir() {
        return this.rootDir;
    }

    @Override
    public boolean isEmpty() {
        return this.subDirs.isEmpty();
    }

    @Override
    public int size() {
        return this.subDirs.size();
    }

    @Override
    public boolean isFirst() {
        return this.lastDirIdx == 0;
    }

    @Override
    public boolean isLast() {
        return !this.subDirs.isEmpty() && this.lastDirIdx == this.subDirs.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File nextDir() {
        Object object = this.lock;
        synchronized (object) {
            if (this.subDirs.isEmpty()) {
                this.refreshDirs();
            }
            if (this.subDirs.isEmpty()) {
                return null;
            }
            int dirIdx = this.lastDirIdx + 1;
            if (dirIdx >= this.subDirs.size()) {
                this.refreshDirs();
                if (this.subDirs.isEmpty()) {
                    return null;
                }
                dirIdx = 0;
            }
            this.statistics.incrementCycles();
            if (dirIdx == 0) {
                long now = System.currentTimeMillis();
                if (this.lastDirIdx > 0 && this.roundtripStartTime > 0L) {
                    this.statistics.addRoundtripTime(now - this.roundtripStartTime);
                }
                this.roundtripStartTime = now;
            }
            this.lastDirIdx = dirIdx;
            File next = this.subDirs.get(dirIdx);
            if (this.stateFile != null) {
                this.saveStateToFile(this.stateFile);
            }
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File peekNextDir() {
        Object object = this.lock;
        synchronized (object) {
            if (this.subDirs.isEmpty()) {
                return null;
            }
            int dirIdx = this.lastDirIdx + 1;
            dirIdx = dirIdx >= this.subDirs.size() ? 0 : dirIdx;
            return this.subDirs.get(dirIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            this.refreshDirs();
            if (this.stateFile != null) {
                this.saveStateToFile(this.stateFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lastDirName() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastDirIdx < 0 || this.lastDirIdx >= this.subDirs.size() - 1 ? null : this.subDirs.get(this.lastDirIdx).getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalDateTime lastDirTimestamp() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stateFile != null && Files.isReadable(this.stateFile.toPath()) && this.lastDirIdx >= 0) {
                return Instant.ofEpochMilli(this.stateFile.lastModified()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreLastDirName(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.refreshDirs();
            this.lastDirIdx = this.getIndexOf(name);
            if (this.stateFile != null) {
                this.saveStateToFile(this.stateFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStateFromFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The file must not be null!");
        }
        Object object = this.lock;
        synchronized (object) {
            if (Files.isRegularFile(file.toPath(), new LinkOption[0])) {
                try {
                    String lastDir = new String(Files.readAllBytes(file.toPath()), Charset.forName("UTF-8"));
                    this.restoreLastDirName(lastDir);
                }
                catch (Exception ex) {
                    throw new AvironException("Failed to load DirCycler state from file", ex);
                }
            } else {
                this.restoreLastDirName(null);
            }
            this.roundtripStartTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStateToFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The file must not be null!");
        }
        Object object = this.lock;
        synchronized (object) {
            String lastDir = this.lastDirName();
            try {
                String data = lastDir == null ? "" : lastDir;
                Files.write(file.toPath(), data.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
            }
            catch (Exception ex) {
                throw new AvironException("Failed to save DirCycler state to file", ex);
            }
        }
    }

    @Override
    public List<File> dirs() {
        return Arrays.stream(this.rootDir.listFiles()).filter(f -> f.isDirectory()).sorted().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCyclerStatistics getStatistics() {
        Object object = this.lock;
        synchronized (object) {
            return new DirCyclerStatistics(this.statistics.getCycles(), this.statistics.getLastRoundtripTimes());
        }
    }

    private void refreshDirs() {
        this.subDirs.clear();
        this.subDirs.addAll(this.dirs());
        if (this.lastDirIdx >= 0 && this.lastDirIdx >= this.subDirs.size()) {
            this.lastDirIdx = -1;
        }
    }

    private int getIndexOf(String name) {
        if (name != null) {
            for (int ii = 0; ii < this.subDirs.size(); ++ii) {
                if (!this.subDirs.get(ii).getName().equals(name)) continue;
                return ii;
            }
        }
        return -1;
    }
}

