/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.filewatcher;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.repackage.com.github.jlangch.aviron.events.FileWatchErrorEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEventType;
import org.repackage.com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import org.repackage.com.github.jlangch.aviron.filewatcher.IFileWatcher;
import org.repackage.com.github.jlangch.aviron.util.service.Service;

public class FileWatcher_JavaWatchService
extends Service
implements IFileWatcher {
    private final Path mainDir;
    private final WatchService ws;
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final AtomicReference<Predicate<FileWatchFileEvent>> fileSelector = new AtomicReference();
    private final AtomicReference<Consumer<FileWatchFileEvent>> fileListener = new AtomicReference();
    private final AtomicReference<Consumer<FileWatchErrorEvent>> errorListener = new AtomicReference();
    private final AtomicReference<Consumer<FileWatchTerminationEvent>> terminationListener = new AtomicReference();

    public FileWatcher_JavaWatchService(Path mainDir, boolean registerAllSubDirs) {
        this(mainDir, registerAllSubDirs, null, null, null);
    }

    public FileWatcher_JavaWatchService(Path mainDir, boolean registerAllSubDirs, Consumer<FileWatchFileEvent> fileListener, Consumer<FileWatchErrorEvent> errorListener, Consumer<FileWatchTerminationEvent> terminationListener) {
        if (mainDir == null) {
            throw new IllegalArgumentException("The mainDir must not be null!");
        }
        if (!Files.isDirectory(mainDir, new LinkOption[0])) {
            throw new RuntimeException("The main dir " + mainDir + " does not exist or is not a directory");
        }
        this.mainDir = mainDir.toAbsolutePath().normalize();
        this.fileListener.set(fileListener);
        this.errorListener.set(errorListener);
        this.terminationListener.set(terminationListener);
        try {
            this.ws = mainDir.getFileSystem().newWatchService();
            if (registerAllSubDirs) {
                Files.walk(mainDir, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this::register);
            } else {
                this.register(mainDir);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create FileWatcher!", ex);
        }
    }

    @Override
    public Path getMainDir() {
        return this.mainDir;
    }

    @Override
    public List<Path> getRegisteredPaths() {
        return this.keys.values().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public void setFileSelector(Predicate<FileWatchFileEvent> selector) {
        this.fileSelector.set(selector);
    }

    @Override
    public void setFileListener(Consumer<FileWatchFileEvent> listener) {
        this.fileListener.set(listener);
    }

    @Override
    public void setErrorListener(Consumer<FileWatchErrorEvent> listener) {
        this.errorListener.set(listener);
    }

    @Override
    public void setTerminationListener(Consumer<FileWatchTerminationEvent> listener) {
        this.terminationListener.set(listener);
    }

    @Override
    protected String name() {
        return "FileWatcher_JavaWatchService";
    }

    @Override
    protected void onStart() {
        this.startServiceThread(this.createWorker());
        this.waitForServiceStarted(5);
    }

    @Override
    protected void onClose() throws IOException {
        this.ws.close();
        this.fireEvent(new FileWatchTerminationEvent(this.mainDir));
    }

    private void register(Path dir) {
        try {
            Path normalizedDir = dir.toAbsolutePath().normalize();
            WatchKey dirKey = normalizedDir.register(this.ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.keys.put(dirKey, normalizedDir);
        }
        catch (Exception e) {
            this.fireEvent(new FileWatchErrorEvent(dir, e));
        }
    }

    private Runnable createWorker() {
        return () -> {
            this.enteredRunningState();
            while (this.isInRunningState()) {
                try {
                    WatchKey key = this.ws.take();
                    if (key == null) break;
                    Path dirPath = this.keys.get(key);
                    if (dirPath == null) continue;
                    key.pollEvents().stream().filter(e -> e.kind() != StandardWatchEventKinds.OVERFLOW).forEach(e -> {
                        Path p = (Path)e.context();
                        Path absPath = dirPath.resolve(p);
                        FileWatchFileEventType eventType = this.convertToEventType(e.kind());
                        if (Files.isDirectory(absPath, new LinkOption[0])) {
                            if (eventType == FileWatchFileEventType.CREATED) {
                                this.register(absPath);
                            }
                            if (eventType != FileWatchFileEventType.CREATED) {
                                this.fireEvent(new FileWatchFileEvent(absPath, true, false, eventType));
                            }
                        } else if (Files.isRegularFile(absPath, new LinkOption[0])) {
                            this.fireEvent(new FileWatchFileEvent(absPath, false, true, eventType));
                        } else {
                            this.fireEvent(new FileWatchFileEvent(absPath, false, false, eventType));
                        }
                    });
                    key.reset();
                }
                catch (ClosedWatchServiceException ex) {
                    break;
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Exception ex) {
                    this.fireEvent(new FileWatchErrorEvent(this.mainDir, ex));
                }
            }
            if (!this.isInClosedState()) {
                this.close();
            }
        };
    }

    private void fireEvent(FileWatchFileEvent event) {
        Consumer<FileWatchFileEvent> listener;
        Predicate<FileWatchFileEvent> selector = this.fileSelector.get();
        if ((selector == null || selector.test(event)) && (listener = this.fileListener.get()) != null) {
            FileWatcher_JavaWatchService.safeRun(() -> listener.accept(event));
        }
    }

    private void fireEvent(FileWatchErrorEvent event) {
        Consumer<FileWatchErrorEvent> listener = this.errorListener.get();
        if (listener != null) {
            FileWatcher_JavaWatchService.safeRun(() -> listener.accept(event));
        }
    }

    private void fireEvent(FileWatchTerminationEvent event) {
        Consumer<FileWatchTerminationEvent> listener = this.terminationListener.get();
        if (listener != null) {
            FileWatcher_JavaWatchService.safeRun(() -> listener.accept(event));
        }
    }

    private static void safeRun(Runnable r) {
        try {
            r.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FileWatchFileEventType convertToEventType(WatchEvent.Kind<?> kind) {
        if (kind == null) {
            return null;
        }
        switch (kind.name()) {
            case "ENTRY_CREATE": {
                return FileWatchFileEventType.CREATED;
            }
            case "ENTRY_DELETE": {
                return FileWatchFileEventType.DELETED;
            }
            case "ENTRY_MODIFY": {
                return FileWatchFileEventType.MODIFIED;
            }
            case "OVERFLOW": {
                return FileWatchFileEventType.OVERFLOW;
            }
        }
        return null;
    }
}

