/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.examples;

import java.nio.file.Path;
import org.repackage.com.github.jlangch.aviron.events.FileWatchErrorEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchFileEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchTerminationEvent;
import org.repackage.com.github.jlangch.aviron.ex.FileWatcherException;
import org.repackage.com.github.jlangch.aviron.filewatcher.FileWatcher_FsWatch;
import org.repackage.com.github.jlangch.aviron.filewatcher.FileWatcher_JavaWatchService;
import org.repackage.com.github.jlangch.aviron.filewatcher.IFileWatcher;
import org.repackage.com.github.jlangch.aviron.util.DemoFilestore;
import org.repackage.com.github.jlangch.aviron.util.OS;
import org.repackage.com.github.jlangch.aviron.util.Util;

public class FileWatcherExample {
    public static void main(String[] args) {
        try {
            new FileWatcherExample().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() throws Exception {
        Util.printfln("Starting ...", new Object[0]);
        try (DemoFilestore demoFS = new DemoFilestore();){
            demoFS.createFilestoreSubDir("000");
            demoFS.createFilestoreSubDir("001");
            Path mainDir = demoFS.getFilestoreDir().toPath();
            boolean registerAllSubDirs = true;
            try (IFileWatcher fw = this.createPlatformFileWatcher(mainDir, true);){
                fw.setFileListener(this::onFileEvent);
                fw.setErrorListener(this::onErrorEvent);
                fw.setTerminationListener(this::onTerminationEvent);
                fw.start();
                Util.printf("Ready to watch \u00ab%s\u00bb%n%n", mainDir);
                demoFS.touchFilestoreFile("000", "test1.data");
                Util.sleep(1000);
                demoFS.appendToFilestoreFile("000", "test1.data");
                Util.sleep(1000);
                demoFS.deleteFilestoreFile("000", "test1.data");
                Util.sleep(3000);
            }
            Util.sleep(1000);
            Util.printfln("Stopped", new Object[0]);
        }
    }

    private IFileWatcher createPlatformFileWatcher(Path mainDir, boolean registerAllSubDirs) {
        if (OS.isLinux()) {
            return new FileWatcher_JavaWatchService(mainDir, registerAllSubDirs);
        }
        if (OS.isMacOSX()) {
            return new FileWatcher_FsWatch(mainDir, registerAllSubDirs, null, "/opt/homebrew/bin/fswatch");
        }
        throw new FileWatcherException("FileWatcher is not supported on platforms other than Linux/MacOS!");
    }

    private void onFileEvent(FileWatchFileEvent event) {
        if (event.isFile()) {
            Util.printfln("File Event: %-8s %s", new Object[]{event.getType(), event.getPath()});
        } else if (event.isDir()) {
            Util.printfln("Dir Event:  %-8s %s", new Object[]{event.getType(), event.getPath()});
        }
    }

    private void onErrorEvent(FileWatchErrorEvent event) {
        Util.printfln("Error:      %s %s", event.getPath(), event.getException().getMessage());
    }

    private void onTerminationEvent(FileWatchTerminationEvent event) {
        Util.printfln("Terminated: %s", event.getPath());
    }
}

