/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ssl;

import com.github.jlangch.venice.impl.util.CollectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class Keystores {
    public static KeyStore load(InputStream is, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(is, password.toCharArray());
        return keystore;
    }

    public static KeyStore load(byte[] ks, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(ks);){
            KeyStore keyStore = Keystores.load(is, password);
            return keyStore;
        }
    }

    public static List<String> aliases(KeyStore keystore) throws KeyStoreException {
        return CollectionUtil.toList(keystore.aliases());
    }

    public static X509Certificate certificate(KeyStore keystore, String alias) throws KeyStoreException {
        return (X509Certificate)keystore.getCertificate(alias);
    }

    public static String subjectDN(KeyStore keystore, String alias) throws KeyStoreException {
        return Keystores.certificate(keystore, alias).getSubjectDN().getName();
    }

    public static Map<String, Object> parseSubjectDN(KeyStore keystore, String alias) {
        try {
            return Keystores.parseDN(Keystores.subjectDN(keystore, alias));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String issuerDN(KeyStore keystore, String alias) throws KeyStoreException {
        return Keystores.certificate(keystore, alias).getIssuerDN().getName();
    }

    public static Map<String, Object> parseIssuerDN(KeyStore keystore, String alias) {
        try {
            return Keystores.parseDN(Keystores.issuerDN(keystore, alias));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static Map<String, Object> parseDN(String dn) {
        try {
            return Keystores.parse(new LdapName(dn));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean hasExpired(KeyStore keystore, String alias) throws KeyStoreException {
        return Keystores.expiryDate(keystore, alias).isBefore(LocalDateTime.now());
    }

    public static LocalDateTime expiryDate(KeyStore keystore, String alias) throws KeyStoreException {
        return Keystores.toLocalDateTime(Keystores.certificate(keystore, alias).getNotAfter());
    }

    public static LocalDateTime expiryDate(KeyStore keystore) throws KeyStoreException {
        Date expiryDate = null;
        for (String alias : Keystores.aliases(keystore)) {
            expiryDate = ((X509Certificate)keystore.getCertificate(alias)).getNotAfter();
        }
        return Keystores.toLocalDateTime(expiryDate);
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        long millis = date.getTime();
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private static Map<String, Object> parse(LdapName ln) {
        HashMap<String, Object> elements = new HashMap<String, Object>();
        for (int ii = 0; ii < ln.size(); ++ii) {
            Rdn rdn = ln.getRdn(ii);
            elements.put(rdn.getType(), rdn.getValue());
        }
        return elements;
    }
}

