/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.pdf;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;

public class ClasspathUserAgent
extends ITextUserAgent {
    private final Map<String, ByteBuffer> cachedResources = new ConcurrentHashMap<String, ByteBuffer>();

    public ClasspathUserAgent(ITextOutputDevice outputDevice, int dotsPerPixel) {
        super(outputDevice, dotsPerPixel);
    }

    public ClasspathUserAgent addResource(String path, ByteBuffer data) {
        if (StringUtil.isBlank(path)) {
            throw new IllegalArgumentException("A 'resource' path must not be blank");
        }
        if (data == null) {
            throw new IllegalArgumentException("A 'resource' data must not be null");
        }
        if (this.isClasspathScheme(path) || this.isMemoryScheme(path)) {
            throw new RuntimeException("An in-memory resource path must not be an URI with a scheme like 'memory:/charts/001.png' just pass '/charts/001.png'. Path was: " + path);
        }
        this.cachedResources.put(path, data);
        return this;
    }

    protected InputStream resolveAndOpenStream(String uri) {
        if (uri == null) {
            return null;
        }
        boolean debug = this.isDebugScheme(uri);
        if (this.isClasspathScheme(uri)) {
            this.log(debug, "FlyingSaucer: Classpath URI=" + uri);
            ByteBuffer data = this.cachedResources.get(uri);
            if (data != null) {
                this.log(debug, String.format("FlyingSaucer: Resolved '" + uri + "' from cache.", new Object[0]));
                return new ByteArrayInputStream(data.array());
            }
            String path = this.stripLeadingSlashes(this.stripScheme(uri));
            data = this.slurp(new ClassPathResource(path));
            if (data != null) {
                byte[] bytes = data.array();
                this.log(debug, String.format("FlyingSaucer: Resolved reource '%s' (%d bytes) from classpath.", path, bytes.length));
                this.cachedResources.put(uri, data);
                return new ByteArrayInputStream(bytes);
            }
            this.log(debug, String.format("FlyingSaucer: Resource '%s' not found on classpath.", path));
            return null;
        }
        if (this.isMemoryScheme(uri)) {
            this.log(debug, "FlyingSaucer: Memory URI=" + uri);
            String path = this.stripScheme(uri);
            ByteBuffer data = this.cachedResources.get(path);
            if (data != null) {
                byte[] bytes = data.array();
                this.log(debug, String.format("FlyingSaucer: Resolved '%s' (%d bytes) from memory.", path, bytes.length));
                return new ByteArrayInputStream(bytes);
            }
            this.log(debug, String.format("FlyingSaucer: Resource '%s' not found in memory.", path));
            return null;
        }
        if (this.isFileScheme(uri)) {
            this.log(debug, "FlyingSaucer: File URI=" + uri);
            ByteBuffer data = this.cachedResources.get(uri);
            if (data != null) {
                this.log(debug, String.format("FlyingSaucer: Resolved '%s' from cache.", uri));
                return new ByteArrayInputStream(data.array());
            }
            String path = this.stripScheme(uri);
            try {
                data = ByteBuffer.wrap(Files.readAllBytes(new File(path).toPath()));
                if (data != null) {
                    byte[] bytes = data.array();
                    this.log(debug, String.format("FlyingSaucer: Resolved reource '%s' (%d bytes) from file.", path, bytes.length));
                    this.cachedResources.put(uri, data);
                    return new ByteArrayInputStream(bytes);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log(debug, String.format("FlyingSaucer: Resource '%s' not found as file.", uri));
            return null;
        }
        this.log(debug, "FlyingSaucer: Unknown URI=" + uri);
        return super.resolveAndOpenStream(uri);
    }

    private boolean isDebugScheme(String uri) {
        return this.isScheme(uri, "classpath-debug:", "memory-debug:", "file-debug:");
    }

    private boolean isClasspathScheme(String uri) {
        return this.isScheme(uri, "classpath:", "classpath-debug:");
    }

    private boolean isMemoryScheme(String uri) {
        return this.isScheme(uri, "memory:", "memory-debug:");
    }

    private boolean isFileScheme(String uri) {
        return this.isScheme(uri, "file:", "file-debug:");
    }

    private boolean isScheme(String uri, String ... scheme) {
        return Arrays.stream(scheme).anyMatch(s -> uri.startsWith((String)s));
    }

    private String stripScheme(String uri) {
        int pos = uri.indexOf(58);
        return pos < 0 ? uri : uri.substring(pos + 1);
    }

    private String stripLeadingSlashes(String path) {
        if (StringUtil.isBlank(path)) {
            return path;
        }
        String p = path.trim();
        while (p.startsWith("/")) {
            p = StringUtil.removeStart(p, "/");
        }
        return p;
    }

    private ByteBuffer slurp(ClassPathResource cpResource) {
        return cpResource.getResourceAsByteBuffer();
    }

    private void log(boolean debug, String message) {
        if (debug) {
            System.out.println(message);
        }
    }
}

