/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.ipc.MessageType;
import com.github.jlangch.venice.util.ipc.ResponseStatus;
import com.github.jlangch.venice.util.ipc.impl.Message;
import com.github.jlangch.venice.util.ipc.impl.Topics;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class PayloadMetaData {
    private final boolean oneway;
    private final MessageType type;
    private final ResponseStatus responseStatus;
    private final String queueName;
    private final Topics topics;
    private final String mimetype;
    private final String charset;
    private final String id;

    public PayloadMetaData(Message msg) {
        this(msg.isOneway(), msg.getType(), msg.getResponseStatus(), msg.getQueueName(), msg.getTopics(), msg.getMimetype(), msg.getCharset(), msg.getId());
    }

    public PayloadMetaData(boolean oneway, MessageType type, ResponseStatus responseStatus, String queueName, Topics topics, String mimetype, String charset, String id) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(responseStatus);
        Objects.requireNonNull(topics);
        Objects.requireNonNull(mimetype);
        Objects.requireNonNull(id);
        this.oneway = oneway;
        this.type = type;
        this.responseStatus = responseStatus;
        this.queueName = queueName;
        this.topics = topics;
        this.mimetype = mimetype;
        this.charset = charset;
        this.id = id;
    }

    public PayloadMetaData(String queueName, Topics topics, String mimetype, String charset, String id) {
        Objects.requireNonNull(topics);
        Objects.requireNonNull(mimetype);
        Objects.requireNonNull(id);
        this.oneway = false;
        this.type = MessageType.NULL;
        this.responseStatus = ResponseStatus.NULL;
        this.queueName = queueName;
        this.topics = topics;
        this.mimetype = mimetype;
        this.charset = charset;
        this.id = id;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public MessageType getType() {
        return this.type;
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Topics getTopics() {
        return this.topics;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.mimetype == null ? 0 : this.mimetype.hashCode());
        result = 31 * result + (this.oneway ? 1231 : 1237);
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.responseStatus == null ? 0 : this.responseStatus.hashCode());
        result = 31 * result + (this.topics == null ? 0 : this.topics.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayloadMetaData other = (PayloadMetaData)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.mimetype == null ? other.mimetype != null : !this.mimetype.equals(other.mimetype)) {
            return false;
        }
        if (this.oneway != other.oneway) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.responseStatus != other.responseStatus) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.type == other.type;
    }

    public static byte[] encode(PayloadMetaData data) {
        Objects.requireNonNull(data);
        String s = (data.oneway ? "1" : "0") + '\n' + PayloadMetaData.toCode(data.type) + '\n' + PayloadMetaData.toCode(data.responseStatus) + '\n' + StringUtil.trimToEmpty(data.queueName) + '\n' + Topics.encode(data.topics) + '\n' + StringUtil.trimToEmpty(data.mimetype) + '\n' + StringUtil.trimToEmpty(data.charset) + '\n' + data.id.toString();
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static PayloadMetaData decode(byte[] data) {
        Objects.requireNonNull(data);
        String s = new String(data, StandardCharsets.UTF_8);
        List<String> lines = StringUtil.splitIntoLines(s);
        if (lines.size() == 8) {
            return new PayloadMetaData(PayloadMetaData.toBool(lines.get(0)), PayloadMetaData.toMessageType(lines.get(1)), PayloadMetaData.toResponseStatus(lines.get(2)), StringUtil.trimToNull(lines.get(3)), Topics.decode(lines.get(4)), lines.get(5), StringUtil.trimToNull(lines.get(6)), lines.get(7));
        }
        throw new VncException(String.format("Failed to decode the payload meta data. Got only %d properties instead of 8!", lines.size()));
    }

    private static boolean toBool(String s) {
        return s.equals("1");
    }

    private static String toCode(MessageType e) {
        return String.valueOf(e.getValue());
    }

    private static String toCode(ResponseStatus e) {
        return String.valueOf(e.getValue());
    }

    private static MessageType toMessageType(String code) {
        MessageType t = MessageType.fromCode(Integer.parseInt(code));
        if (t == null) {
            throw new VncException("Illegal IPC message MessageType value");
        }
        return t;
    }

    private static ResponseStatus toResponseStatus(String code) {
        ResponseStatus s = ResponseStatus.fromCode(Integer.parseInt(code));
        if (s == null) {
            throw new VncException("Illegal IPC message ResponseStatus value");
        }
        return s;
    }
}

