/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl.util;

import com.github.jlangch.venice.impl.util.io.zip.GZipper;
import java.util.Objects;

public class Compressor {
    private final long cutoffSize;

    public Compressor(long cutoffSize) {
        this.cutoffSize = cutoffSize < 0L ? -1L : cutoffSize;
    }

    public static Compressor off() {
        return new Compressor(-1L);
    }

    public byte[] compress(byte[] data) {
        Objects.requireNonNull(data);
        return this.compress(data, this.needsCompression(data));
    }

    public byte[] compress(byte[] data, boolean compress) {
        Objects.requireNonNull(data);
        return compress ? GZipper.gzip(data) : data;
    }

    public byte[] decompress(byte[] data, boolean decompress) {
        Objects.requireNonNull(data);
        return decompress ? GZipper.ungzip(data) : data;
    }

    public long cutoffSize() {
        return this.cutoffSize;
    }

    public boolean needsCompression(byte[] data) {
        return this.cutoffSize >= 0L && (long)data.length >= this.cutoffSize;
    }
}

